/*
 * Decompiled with CFR 0.152.
 */
package brave.sampler;

import brave.propagation.SamplingFlags;
import brave.sampler.CountingSampler;
import brave.sampler.Sampler;
import java.util.List;
import javax.annotation.Nullable;

public final class ParameterizedSampler<P> {
    final List<? extends Rule<P>> rules;

    public static final <P> ParameterizedSampler<P> create(List<? extends Rule<P>> rules) {
        if (rules == null) {
            throw new NullPointerException("rules == null");
        }
        return new ParameterizedSampler<P>(rules);
    }

    ParameterizedSampler(List<? extends Rule<P>> rules) {
        this.rules = rules;
    }

    public SamplingFlags sample(@Nullable P parameters) {
        if (parameters == null) {
            return SamplingFlags.EMPTY;
        }
        for (Rule<P> rule : this.rules) {
            if (!rule.matches(parameters)) continue;
            return rule.isSampled();
        }
        return SamplingFlags.EMPTY;
    }

    public static abstract class Rule<P> {
        final Sampler sampler;

        protected Rule(float rate) {
            this.sampler = CountingSampler.create(rate);
        }

        public abstract boolean matches(P var1);

        SamplingFlags isSampled() {
            return this.sampler.isSampled(0L) ? SamplingFlags.SAMPLED : SamplingFlags.NOT_SAMPLED;
        }
    }
}

