/*
 * Decompiled with CFR 0.152.
 */
package brave.internal.recorder;

import brave.Span;
import brave.internal.HexCodec;
import brave.propagation.TraceContext;
import javax.annotation.Nullable;
import zipkin2.Endpoint;
import zipkin2.Span;

final class MutableSpan {
    final Span.Builder span;
    boolean finished;
    long timestamp;

    MutableSpan(TraceContext context, Endpoint localEndpoint) {
        this.span = Span.newBuilder().traceId(context.traceIdString()).parentId(context.parentId() != null ? HexCodec.toLowerHex(context.parentId()) : null).id(HexCodec.toLowerHex(context.spanId())).debug(Boolean.valueOf(context.debug())).shared(Boolean.valueOf(context.shared())).localEndpoint(localEndpoint);
        this.finished = false;
    }

    synchronized MutableSpan start(long timestamp) {
        this.timestamp = timestamp;
        this.span.timestamp(Long.valueOf(this.timestamp));
        return this;
    }

    synchronized MutableSpan name(String name) {
        this.span.name(name);
        return this;
    }

    synchronized MutableSpan kind(Span.Kind kind) {
        try {
            this.span.kind(Span.Kind.valueOf((String)kind.name()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return this;
    }

    synchronized MutableSpan annotate(long timestamp, String value) {
        if ("cs".equals(value)) {
            this.timestamp = timestamp;
            this.span.kind(Span.Kind.CLIENT).timestamp(Long.valueOf(this.timestamp));
        } else if ("sr".equals(value)) {
            this.timestamp = timestamp;
            this.span.kind(Span.Kind.SERVER).timestamp(Long.valueOf(this.timestamp));
        } else if ("cr".equals(value)) {
            this.span.kind(Span.Kind.CLIENT);
            this.finish(timestamp);
        } else if ("ss".equals(value)) {
            this.span.kind(Span.Kind.SERVER);
            this.finish(timestamp);
        } else {
            this.span.addAnnotation(timestamp, value);
        }
        return this;
    }

    synchronized MutableSpan tag(String key, String value) {
        this.span.putTag(key, value);
        return this;
    }

    synchronized MutableSpan remoteEndpoint(Endpoint remoteEndpoint) {
        this.span.remoteEndpoint(remoteEndpoint);
        return this;
    }

    synchronized MutableSpan finish(@Nullable Long finishTimestamp) {
        if (this.finished) {
            return this;
        }
        this.finished = true;
        if (this.timestamp != 0L && finishTimestamp != null) {
            this.span.duration(Long.valueOf(Math.max(finishTimestamp - this.timestamp, 1L)));
        }
        return this;
    }

    synchronized Span toSpan() {
        return this.span.build();
    }
}

