/*
 * Decompiled with CFR 0.152.
 */
package brave.internal;

import brave.Clock;
import brave.Tracer;
import brave.internal.AutoValue_Platform_Jre6;
import brave.internal.AutoValue_Platform_Jre7;
import com.google.auto.value.AutoValue;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.animal_sniffer.IgnoreJRERequirement;
import zipkin2.Endpoint;
import zipkin2.Span;
import zipkin2.reporter.Reporter;

public abstract class Platform
implements Clock,
Reporter<Span> {
    static final Logger logger = Logger.getLogger(Tracer.class.getName());
    private static final Platform PLATFORM = Platform.findPlatform();
    final long createTimestamp = System.currentTimeMillis() * 1000L;
    final long createTick = System.nanoTime();
    volatile Endpoint localEndpoint;

    Platform() {
    }

    public abstract boolean zipkinV1Present();

    public void report(Span span) {
        if (!logger.isLoggable(Level.INFO)) {
            return;
        }
        if (span == null) {
            throw new NullPointerException("span == null");
        }
        logger.info(span.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Endpoint localEndpoint() {
        if (this.localEndpoint == null) {
            Platform platform = this;
            synchronized (platform) {
                if (this.localEndpoint == null) {
                    this.localEndpoint = this.produceLocalEndpoint();
                }
            }
        }
        return this.localEndpoint;
    }

    Endpoint produceLocalEndpoint() {
        Endpoint.Builder builder;
        block5: {
            builder = Endpoint.newBuilder().serviceName("unknown");
            try {
                Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
                if (nics == null) {
                    return builder.build();
                }
                block2: while (nics.hasMoreElements()) {
                    NetworkInterface nic = nics.nextElement();
                    Enumeration<InetAddress> addresses = nic.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        InetAddress address = addresses.nextElement();
                        if (!address.isSiteLocalAddress()) continue;
                        builder.ip(address);
                        continue block2;
                    }
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.FINE)) break block5;
                logger.log(Level.FINE, "error reading nics", e);
            }
        }
        return builder.build();
    }

    public static Platform get() {
        return PLATFORM;
    }

    static Platform findPlatform() {
        boolean zipkinV1Present;
        try {
            Class.forName("zipkin.Endpoint");
            zipkinV1Present = true;
        }
        catch (ClassNotFoundException e) {
            zipkinV1Present = false;
        }
        Jre7 jre7 = Jre7.buildIfSupported(zipkinV1Present);
        if (jre7 != null) {
            return jre7;
        }
        return Jre6.build(zipkinV1Present);
    }

    public abstract long randomLong();

    @Override
    public long currentTimeMicroseconds() {
        return (System.nanoTime() - this.createTick) / 1000L + this.createTimestamp;
    }

    @AutoValue
    static abstract class Jre6
    extends Platform {
        Jre6() {
        }

        abstract Random prng();

        static Jre6 build(boolean zipkinV1Present) {
            return new AutoValue_Platform_Jre6(zipkinV1Present, new Random(System.nanoTime()));
        }

        @Override
        public long randomLong() {
            return this.prng().nextLong();
        }
    }

    @AutoValue
    static abstract class Jre7
    extends Platform {
        Jre7() {
        }

        static Jre7 buildIfSupported(boolean zipkinV1Present) {
            try {
                Class.forName("java.util.concurrent.ThreadLocalRandom");
                return new AutoValue_Platform_Jre7(zipkinV1Present);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }

        @Override
        @IgnoreJRERequirement
        public long randomLong() {
            return ThreadLocalRandom.current().nextLong();
        }
    }
}

