/*
 * Decompiled with CFR 0.152.
 */
package brave;

import brave.Clock;
import brave.Tracer;
import brave.internal.Internal;
import brave.internal.Platform;
import brave.internal.zipkin.V2SpanConverter;
import brave.propagation.CurrentTraceContext;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.sampler.Sampler;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import zipkin.reporter.Reporter;
import zipkin2.Endpoint;
import zipkin2.Span;

public abstract class Tracing
implements Closeable {
    static volatile Tracing current = null;
    final AtomicBoolean noop = new AtomicBoolean(false);

    public static Builder newBuilder() {
        return new Builder();
    }

    public abstract Tracer tracer();

    public Propagation<String> propagation() {
        return this.propagationFactory().create(Propagation.KeyFactory.STRING);
    }

    public abstract Propagation.Factory propagationFactory();

    public abstract CurrentTraceContext currentTraceContext();

    public abstract Clock clock();

    @Nullable
    public static Tracer currentTracer() {
        Tracing tracing = current;
        return tracing != null ? tracing.tracer() : null;
    }

    public boolean isNoop() {
        return this.noop.get();
    }

    public void setNoop(boolean noop) {
        this.noop.set(noop);
    }

    @Nullable
    public static Tracing current() {
        return current;
    }

    @Override
    public abstract void close();

    static {
        Internal.instance = new Internal(){

            @Override
            public Long timestamp(Tracer tracer, TraceContext context) {
                return tracer.recorder.timestamp(context);
            }
        };
    }

    static final class Default
    extends Tracing {
        final Tracer tracer;
        final Propagation.Factory propagationFactory;
        final Propagation<String> stringPropagation;
        final CurrentTraceContext currentTraceContext;
        final Clock clock;

        Default(Builder builder) {
            this.tracer = new Tracer(builder, this.noop);
            this.propagationFactory = builder.propagationFactory;
            this.stringPropagation = builder.propagationFactory.create(Propagation.KeyFactory.STRING);
            this.currentTraceContext = builder.currentTraceContext;
            this.clock = builder.clock;
            this.maybeSetCurrent();
        }

        @Override
        public Tracer tracer() {
            return this.tracer;
        }

        @Override
        public Propagation<String> propagation() {
            return this.stringPropagation;
        }

        @Override
        public Propagation.Factory propagationFactory() {
            return this.propagationFactory;
        }

        @Override
        public CurrentTraceContext currentTraceContext() {
            return this.currentTraceContext;
        }

        @Override
        public Clock clock() {
            return this.clock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void maybeSetCurrent() {
            if (current != null) {
                return;
            }
            Class<Tracing> clazz = Tracing.class;
            synchronized (Tracing.class) {
                if (current == null) {
                    current = this;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            if (current != this) {
                return;
            }
            Class<Tracing> clazz = Tracing.class;
            synchronized (Tracing.class) {
                if (current == this) {
                    current = null;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }

    public static final class Builder {
        String localServiceName;
        Endpoint localEndpoint;
        zipkin2.reporter.Reporter<Span> reporter;
        Clock clock;
        Sampler sampler = Sampler.ALWAYS_SAMPLE;
        CurrentTraceContext currentTraceContext = CurrentTraceContext.Default.inheritable();
        boolean traceId128Bit = false;
        Propagation.Factory propagationFactory = Propagation.Factory.B3;

        public Builder localServiceName(String localServiceName) {
            if (localServiceName == null) {
                throw new NullPointerException("localServiceName == null");
            }
            this.localServiceName = localServiceName;
            return this;
        }

        @Deprecated
        public Builder localEndpoint(zipkin.Endpoint localEndpoint) {
            return this.localEndpoint(localEndpoint.toV2());
        }

        public Builder localEndpoint(Endpoint localEndpoint) {
            if (localEndpoint == null) {
                throw new NullPointerException("localEndpoint == null");
            }
            this.localEndpoint = localEndpoint;
            return this;
        }

        public Builder spanReporter(zipkin2.reporter.Reporter<Span> reporter) {
            if (reporter == null) {
                throw new NullPointerException("spanReporter == null");
            }
            this.reporter = reporter;
            return this;
        }

        @Deprecated
        public Builder reporter(final Reporter<zipkin.Span> reporter) {
            if (reporter == null) {
                throw new NullPointerException("spanReporter == null");
            }
            if (reporter == Reporter.NOOP) {
                this.reporter = zipkin2.reporter.Reporter.NOOP;
                return this;
            }
            this.reporter = new zipkin2.reporter.Reporter<Span>(){

                public void report(Span span) {
                    reporter.report((Object)V2SpanConverter.toSpan(span));
                }

                public String toString() {
                    return reporter.toString();
                }
            };
            return this;
        }

        public Builder clock(Clock clock) {
            if (clock == null) {
                throw new NullPointerException("clock == null");
            }
            this.clock = clock;
            return this;
        }

        public Builder sampler(Sampler sampler) {
            this.sampler = sampler;
            return this;
        }

        public Builder currentTraceContext(CurrentTraceContext currentTraceContext) {
            this.currentTraceContext = currentTraceContext;
            return this;
        }

        public Builder propagationFactory(Propagation.Factory propagationFactory) {
            if (propagationFactory == null) {
                throw new NullPointerException("propagationFactory == null");
            }
            this.propagationFactory = propagationFactory;
            return this;
        }

        public Builder traceId128Bit(boolean traceId128Bit) {
            this.traceId128Bit = traceId128Bit;
            return this;
        }

        public Tracing build() {
            if (this.clock == null) {
                this.clock = Platform.get();
            }
            if (this.localEndpoint == null) {
                this.localEndpoint = Platform.get().localEndpoint();
                if (this.localServiceName != null) {
                    this.localEndpoint = this.localEndpoint.toBuilder().serviceName(this.localServiceName).build();
                }
            }
            if (this.reporter == null) {
                this.reporter = Platform.get();
            }
            return new Default(this);
        }

        Builder() {
        }
    }
}

