/*
 * Decompiled with CFR 0.152.
 */
package brave;

import brave.Clock;
import brave.NoopSpan;
import brave.RealSpan;
import brave.Span;
import brave.Tracing;
import brave.internal.Platform;
import brave.internal.recorder.Recorder;
import brave.propagation.CurrentTraceContext;
import brave.propagation.SamplingFlags;
import brave.propagation.TraceContext;
import brave.sampler.Sampler;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import zipkin.reporter.Reporter;
import zipkin2.Endpoint;

public final class Tracer {
    final Clock clock;
    final Recorder recorder;
    final Sampler sampler;
    final CurrentTraceContext currentTraceContext;
    final boolean traceId128Bit;
    final AtomicBoolean noop;
    final boolean supportsJoin;

    @Deprecated
    public static Builder newBuilder() {
        return new Builder();
    }

    Tracer(Tracing.Builder builder, AtomicBoolean noop) {
        this.noop = noop;
        this.supportsJoin = builder.propagationFactory.supportsJoin();
        this.clock = builder.clock;
        this.recorder = new Recorder(builder.localEndpoint, this.clock, builder.reporter, this.noop);
        this.sampler = builder.sampler;
        this.currentTraceContext = builder.currentTraceContext;
        this.traceId128Bit = builder.traceId128Bit;
    }

    @Deprecated
    public Clock clock() {
        return this.clock;
    }

    public Span newTrace() {
        return this.toSpan(this.nextContext(null, SamplingFlags.EMPTY));
    }

    public final Span joinSpan(TraceContext context) {
        if (context == null) {
            throw new NullPointerException("context == null");
        }
        if (!this.supportsJoin) {
            return this.newChild(context);
        }
        TraceContext.Builder builder = context.toBuilder();
        if (context.sampled() == null) {
            builder.sampled(this.sampler.isSampled(context.traceId()));
        } else {
            builder.shared(true);
        }
        return this.toSpan(builder.build());
    }

    public Span newTrace(SamplingFlags samplingFlags) {
        return this.toSpan(this.nextContext(null, samplingFlags));
    }

    public Span toSpan(TraceContext context) {
        if (context == null) {
            throw new NullPointerException("context == null");
        }
        if (!this.noop.get() && Boolean.TRUE.equals(context.sampled())) {
            return RealSpan.create(context, this.clock, this.recorder);
        }
        return NoopSpan.create(context);
    }

    public Span newChild(TraceContext parent) {
        if (parent == null) {
            throw new NullPointerException("parent == null");
        }
        if (Boolean.FALSE.equals(parent.sampled())) {
            return NoopSpan.create(parent);
        }
        return this.toSpan(this.nextContext(parent, parent));
    }

    TraceContext nextContext(@Nullable TraceContext parent, SamplingFlags samplingFlags) {
        long nextId = Platform.get().randomLong();
        if (parent != null) {
            return parent.toBuilder().spanId(nextId).parentId(parent.spanId()).shared(false).build();
        }
        Boolean sampled = samplingFlags.sampled();
        if (sampled == null) {
            sampled = this.sampler.isSampled(nextId);
        }
        return TraceContext.newBuilder().sampled(sampled).debug(samplingFlags.debug()).traceIdHigh(this.traceId128Bit ? Platform.get().randomLong() : 0L).traceId(nextId).spanId(nextId).build();
    }

    public SpanInScope withSpanInScope(@Nullable Span span) {
        return new SpanInScope(this.currentTraceContext.newScope(span != null ? span.context() : null));
    }

    @Nullable
    public Span currentSpan() {
        TraceContext currentContext = this.currentTraceContext.get();
        return currentContext != null ? this.toSpan(currentContext) : null;
    }

    public Span nextSpan() {
        TraceContext parent = this.currentTraceContext.get();
        return parent == null ? this.newTrace() : this.newChild(parent);
    }

    public static final class SpanInScope
    implements Closeable {
        final CurrentTraceContext.Scope scope;

        SpanInScope(CurrentTraceContext.Scope scope) {
            if (scope == null) {
                throw new NullPointerException("scope == null");
            }
            this.scope = scope;
        }

        @Override
        public void close() {
            this.scope.close();
        }

        public String toString() {
            return this.scope.toString();
        }
    }

    @Deprecated
    public static final class Builder {
        final Tracing.Builder delegate = new Tracing.Builder();

        public Builder localServiceName(String localServiceName) {
            this.delegate.localServiceName(localServiceName);
            return this;
        }

        @Deprecated
        public Builder localEndpoint(zipkin.Endpoint localEndpoint) {
            return this.localEndpoint(localEndpoint.toV2());
        }

        public Builder localEndpoint(Endpoint localEndpoint) {
            this.delegate.localEndpoint(localEndpoint);
            return this;
        }

        @Deprecated
        public Builder reporter(Reporter<zipkin.Span> reporter) {
            this.delegate.reporter(reporter);
            return this;
        }

        public Builder spanReporter(zipkin2.reporter.Reporter<zipkin2.Span> reporter) {
            this.delegate.spanReporter(reporter);
            return this;
        }

        public Builder clock(Clock clock) {
            this.delegate.clock(clock);
            return this;
        }

        public Builder sampler(Sampler sampler) {
            this.delegate.sampler(sampler);
            return this;
        }

        public Builder currentTraceContext(CurrentTraceContext currentTraceContext) {
            this.delegate.currentTraceContext(currentTraceContext);
            return this;
        }

        public Builder traceId128Bit(boolean traceId128Bit) {
            this.delegate.traceId128Bit(traceId128Bit);
            return this;
        }

        public Tracer build() {
            return this.delegate.build().tracer();
        }
    }
}

