/*
 * Decompiled with CFR 0.152.
 */
package brave.propagation;

import brave.internal.HexCodec;
import brave.internal.Nullable;
import brave.propagation.SamplingFlags;

public final class TraceIdContext
extends SamplingFlags {
    final long traceIdHigh;
    final long traceId;
    final int flags;

    public static Builder newBuilder() {
        return new Builder();
    }

    public long traceIdHigh() {
        return this.traceIdHigh;
    }

    public long traceId() {
        return this.traceId;
    }

    @Override
    @Nullable
    public Boolean sampled() {
        return TraceIdContext.sampled(this.flags);
    }

    @Override
    public boolean debug() {
        return TraceIdContext.debug(this.flags);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String toString() {
        boolean traceHi = this.traceIdHigh != 0L;
        char[] result = new char[traceHi ? 32 : 16];
        int pos = 0;
        if (traceHi) {
            HexCodec.writeHexLong(result, pos, this.traceIdHigh);
            pos += 16;
        }
        HexCodec.writeHexLong(result, pos, this.traceId);
        return new String(result);
    }

    TraceIdContext(Builder builder) {
        this.traceIdHigh = builder.traceIdHigh;
        this.traceId = builder.traceId;
        this.flags = builder.flags;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TraceIdContext)) {
            return false;
        }
        TraceIdContext that = (TraceIdContext)o;
        return this.traceIdHigh == that.traceIdHigh && this.traceId == that.traceId;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= (int)(this.traceIdHigh >>> 32 ^ this.traceIdHigh);
        h *= 1000003;
        return h ^= (int)(this.traceId >>> 32 ^ this.traceId);
    }

    public static final class Builder {
        long traceIdHigh;
        long traceId;
        int flags = 0;

        Builder(TraceIdContext context) {
            this.traceIdHigh = context.traceIdHigh;
            this.traceId = context.traceId;
            this.flags = context.flags;
        }

        public Builder traceIdHigh(long traceIdHigh) {
            this.traceIdHigh = traceIdHigh;
            return this;
        }

        public Builder traceId(long traceId) {
            this.traceId = traceId;
            return this;
        }

        public Builder sampled(boolean sampled) {
            this.flags |= 4;
            this.flags = sampled ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
            return this;
        }

        public Builder sampled(@Nullable Boolean sampled) {
            if (sampled != null) {
                return this.sampled((boolean)sampled);
            }
            this.flags &= 0xFFFFFFFB;
            return this;
        }

        public Builder debug(boolean debug) {
            this.flags = debug ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
            return this;
        }

        public final TraceIdContext build() {
            if (this.traceId == 0L) {
                throw new IllegalStateException("Missing: traceId");
            }
            return new TraceIdContext(this);
        }

        Builder() {
        }
    }
}

