/*
 * Decompiled with CFR 0.152.
 */
package brave.propagation;

import brave.Tracing;
import brave.internal.Nullable;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class ExtraFieldPropagation<K>
implements Propagation<K> {
    final Propagation<K> delegate;
    final String[] fieldNames;
    final List<K> keys;
    final List<K> allKeys;

    public static Propagation.Factory newFactory(Propagation.Factory delegate, String ... fieldNames) {
        if (delegate == null) {
            throw new NullPointerException("delegate == null");
        }
        if (fieldNames == null) {
            throw new NullPointerException("fieldNames == null");
        }
        String[] validated = ExtraFieldPropagation.ensureLowerCase(Arrays.asList(fieldNames));
        return new Factory(delegate, validated, validated);
    }

    public static Propagation.Factory newFactory(Propagation.Factory delegate, Collection<String> fieldNames) {
        if (delegate == null) {
            throw new NullPointerException("delegate == null");
        }
        if (fieldNames == null) {
            throw new NullPointerException("fieldNames == null");
        }
        String[] validated = ExtraFieldPropagation.ensureLowerCase(fieldNames);
        return new Factory(delegate, validated, validated);
    }

    public static FactoryBuilder newFactoryBuilder(Propagation.Factory delegate) {
        return new FactoryBuilder(delegate);
    }

    @Nullable
    public static String current(String name) {
        return ExtraFieldPropagation.get(name);
    }

    @Nullable
    public static String get(String name) {
        TraceContext context = ExtraFieldPropagation.currentTraceContext();
        return context != null ? ExtraFieldPropagation.get(context, name) : null;
    }

    public static void set(String name, String value) {
        TraceContext context = ExtraFieldPropagation.currentTraceContext();
        if (context != null) {
            ExtraFieldPropagation.set(context, name, value);
        }
    }

    public static Map<String, String> getAll() {
        TraceContext context = ExtraFieldPropagation.currentTraceContext();
        if (context == null) {
            return Collections.emptyMap();
        }
        return ExtraFieldPropagation.getAll(context);
    }

    public static Map<String, String> getAll(TraceContextOrSamplingFlags extracted) {
        if (extracted == null) {
            throw new NullPointerException("extracted == null");
        }
        return extracted.context() != null ? ExtraFieldPropagation.getAll(extracted.context()) : ExtraFieldPropagation.getAll(extracted.extra());
    }

    public static Map<String, String> getAll(TraceContext context) {
        if (context == null) {
            throw new NullPointerException("context == null");
        }
        return ExtraFieldPropagation.getAll(context.extra());
    }

    @Nullable
    static TraceContext currentTraceContext() {
        Tracing tracing = Tracing.current();
        return tracing != null ? tracing.currentTraceContext().get() : null;
    }

    @Nullable
    public static String get(TraceContext context, String name) {
        if (context == null) {
            throw new NullPointerException("context == null");
        }
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        Extra extra = ExtraFieldPropagation.findExtra(context.extra());
        if (extra == null) {
            return null;
        }
        int index = extra.indexOf(name.toLowerCase(Locale.ROOT));
        return index != -1 ? extra.get(index) : null;
    }

    public static void set(TraceContext context, String name, String value) {
        if (context == null) {
            throw new NullPointerException("context == null");
        }
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        if (value == null) {
            throw new NullPointerException("value == null");
        }
        Extra extra = ExtraFieldPropagation.findExtra(context.extra());
        if (extra == null) {
            return;
        }
        int index = extra.indexOf(name.toLowerCase(Locale.ROOT));
        if (index == -1) {
            return;
        }
        extra.set(index, value);
    }

    ExtraFieldPropagation(Propagation<K> delegate, String[] fieldNames, List<K> keys) {
        this.delegate = delegate;
        this.fieldNames = fieldNames;
        this.keys = keys;
        ArrayList<K> allKeys = new ArrayList<K>(delegate.keys());
        allKeys.addAll(keys);
        this.allKeys = allKeys;
    }

    @Override
    public List<K> keys() {
        return this.allKeys;
    }

    @Override
    public <C> TraceContext.Injector<C> injector(Propagation.Setter<C, K> setter) {
        return new ExtraFieldInjector<C, K>(this, setter);
    }

    @Override
    public <C> TraceContext.Extractor<C> extractor(Propagation.Getter<C, K> getter) {
        return new ExtraFieldExtractor<C, K>(this, getter);
    }

    static Extra findExtra(List<Object> extra) {
        int i = ExtraFieldPropagation.indexOfExtra(extra);
        return i != -1 ? (Extra)extra.get(i) : null;
    }

    static int indexOfExtra(List<Object> extra) {
        int length = extra.size();
        for (int i = 0; i < length; ++i) {
            if (!(extra.get(i) instanceof Extra)) continue;
            return i;
        }
        return -1;
    }

    static String[] ensureLowerCase(Collection<String> names) {
        if (names.isEmpty()) {
            throw new IllegalArgumentException("names is empty");
        }
        Iterator<String> nextName = names.iterator();
        String[] result = new String[names.size()];
        int i = 0;
        while (nextName.hasNext()) {
            String name = nextName.next();
            if (name == null) {
                throw new NullPointerException("names[" + i + "] == null");
            }
            if ((name = name.trim()).isEmpty()) {
                throw new IllegalArgumentException("names[" + i + "] is empty");
            }
            result[i] = name.toLowerCase(Locale.ROOT);
            ++i;
        }
        return result;
    }

    static Map<String, String> getAll(List<Object> extraList) {
        Extra extra = ExtraFieldPropagation.findExtra(extraList);
        if (extra == null) {
            return Collections.emptyMap();
        }
        String[] elements = extra.values;
        if (elements == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        int length = elements.length;
        for (int i = 0; i < length; ++i) {
            String value = elements[i];
            if (value == null) continue;
            result.put(extra.fieldNames[i], value);
        }
        return result;
    }

    static final class ExtraFieldExtractor<C, K>
    implements TraceContext.Extractor<C> {
        final ExtraFieldPropagation<K> propagation;
        final TraceContext.Extractor<C> delegate;
        final Propagation.Getter<C, K> getter;

        ExtraFieldExtractor(ExtraFieldPropagation<K> propagation, Propagation.Getter<C, K> getter) {
            this.propagation = propagation;
            this.delegate = propagation.delegate.extractor(getter);
            this.getter = getter;
        }

        @Override
        public TraceContextOrSamplingFlags extract(C carrier) {
            TraceContextOrSamplingFlags result = this.delegate.extract(carrier);
            Extra extra = new Extra(this.propagation.fieldNames);
            int length = this.propagation.fieldNames.length;
            for (int i = 0; i < length; ++i) {
                String maybeValue = this.getter.get(carrier, this.propagation.keys.get(i));
                if (maybeValue == null) continue;
                extra.set(i, maybeValue);
            }
            return result.toBuilder().addExtra(extra).build();
        }
    }

    static final class ExtraFieldInjector<C, K>
    implements TraceContext.Injector<C> {
        final TraceContext.Injector<C> delegate;
        final Propagation.Setter<C, K> setter;
        final String[] fieldNames;
        final List<K> keys;

        ExtraFieldInjector(ExtraFieldPropagation<K> propagation, Propagation.Setter<C, K> setter) {
            this.delegate = propagation.delegate.injector(setter);
            this.fieldNames = propagation.fieldNames;
            this.keys = propagation.keys;
            this.setter = setter;
        }

        @Override
        public void inject(TraceContext traceContext, C carrier) {
            this.delegate.inject(traceContext, carrier);
            int extraIndex = ExtraFieldPropagation.indexOfExtra(traceContext.extra());
            if (extraIndex == -1) {
                return;
            }
            Extra extra = (Extra)traceContext.extra().get(extraIndex);
            int length = this.keys.size();
            for (int i = 0; i < length; ++i) {
                String maybeValue = extra.get(i);
                if (maybeValue == null) continue;
                this.setter.put(carrier, this.keys.get(i), maybeValue);
            }
        }
    }

    static final class Extra
    implements Cloneable {
        final String[] fieldNames;
        volatile String[] values;
        TraceContext context;

        Extra(String[] fieldNames) {
            this.fieldNames = fieldNames;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean tryAssociate(TraceContext newContext) {
            Extra extra = this;
            synchronized (extra) {
                if (this.context == null) {
                    this.context = newContext;
                    return true;
                }
                return this.context.traceId() == newContext.traceId() && this.context.spanId() == newContext.spanId();
            }
        }

        int indexOf(String name) {
            int length = this.fieldNames.length;
            for (int i = 0; i < length; ++i) {
                if (!this.fieldNames[i].equals(name)) continue;
                return i;
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void set(int index, String value) {
            Extra extra = this;
            synchronized (extra) {
                String[] elements = this.values;
                if (elements == null) {
                    elements = new String[this.fieldNames.length];
                    elements[index] = value;
                } else if (!value.equals(elements[index])) {
                    elements = Arrays.copyOf(elements, elements.length);
                    elements[index] = value;
                }
                this.values = elements;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String get(int index) {
            String result;
            Extra extra = this;
            synchronized (extra) {
                String[] elements = this.values;
                result = elements != null ? elements[index] : null;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            String[] elements;
            Extra extra = this;
            synchronized (extra) {
                elements = this.values;
            }
            if (elements == null) {
                return "ExtraFieldPropagation{}";
            }
            LinkedHashMap<String, String> contents = new LinkedHashMap<String, String>();
            int length = this.fieldNames.length;
            for (int i = 0; i < length; ++i) {
                String maybeValue = elements[i];
                if (maybeValue == null) continue;
                contents.put(this.fieldNames[i], maybeValue);
            }
            return "ExtraFieldPropagation" + contents;
        }

        public Extra clone() {
            Extra result = new Extra(this.fieldNames);
            result.values = this.values;
            return result;
        }
    }

    static final class Factory
    extends Propagation.Factory {
        final Propagation.Factory delegate;
        final String[] fieldNames;
        final String[] keyNames;

        Factory(Propagation.Factory delegate, String[] fieldNames, String[] keyNames) {
            this.delegate = delegate;
            this.fieldNames = fieldNames;
            this.keyNames = keyNames;
        }

        @Override
        public boolean supportsJoin() {
            return this.delegate.supportsJoin();
        }

        @Override
        public boolean requires128BitTraceId() {
            return this.delegate.requires128BitTraceId();
        }

        @Override
        public final <K> Propagation<K> create(Propagation.KeyFactory<K> keyFactory) {
            int length = this.fieldNames.length;
            ArrayList<K> keys = new ArrayList<K>(length);
            for (int i = 0; i < length; ++i) {
                keys.add(keyFactory.create(this.keyNames[i]));
            }
            return new ExtraFieldPropagation<K>(this.delegate.create(keyFactory), this.fieldNames, keys);
        }

        @Override
        public TraceContext decorate(TraceContext context) {
            TraceContext resultContext;
            Extra extra;
            TraceContext result = this.delegate.decorate(context);
            List<Object> extras = result.extra();
            int thisExtraIndex = -1;
            int parentExtraIndex = -1;
            int length = extras.size();
            for (int i = 0; i < length; ++i) {
                if (!(extras.get(i) instanceof Extra)) continue;
                Extra extra2 = (Extra)result.extra().get(i);
                if (!Arrays.equals(extra2.fieldNames, this.fieldNames)) {
                    throw new IllegalStateException(String.format("Mixed name configuration unsupported: found %s, expected %s", Arrays.toString(extra2.fieldNames), Arrays.toString(this.fieldNames)));
                }
                if (extra2.tryAssociate(context)) {
                    thisExtraIndex = i;
                    continue;
                }
                parentExtraIndex = i;
            }
            if (thisExtraIndex != -1 && parentExtraIndex == -1) {
                return context;
            }
            ArrayList<Object> copyOfExtra = new ArrayList<Object>(result.extra());
            if (thisExtraIndex == -1 && parentExtraIndex != -1) {
                extra = ((Extra)copyOfExtra.get(parentExtraIndex)).clone();
                copyOfExtra.set(parentExtraIndex, extra);
            } else if (thisExtraIndex != -1 && parentExtraIndex != -1) {
                extra = (Extra)copyOfExtra.get(thisExtraIndex);
                Extra parent = (Extra)copyOfExtra.remove(parentExtraIndex);
                if (parent.values != null) {
                    for (int i = 0; i < parent.values.length; ++i) {
                        if (parent.values[i] == null || extra.get(i) != null) continue;
                        extra.set(i, parent.values[i]);
                    }
                }
            } else {
                extra = new Extra(this.fieldNames);
                copyOfExtra.add(extra);
            }
            extra.context = resultContext = result.toBuilder().extra(Collections.unmodifiableList(copyOfExtra)).build();
            return resultContext;
        }
    }

    public static final class FactoryBuilder {
        final Propagation.Factory delegate;
        List<String> fieldNames = new ArrayList<String>();
        Map<String, String[]> prefixedNames = new LinkedHashMap<String, String[]>();

        FactoryBuilder(Propagation.Factory delegate) {
            if (delegate == null) {
                throw new NullPointerException("delegate == null");
            }
            this.delegate = delegate;
        }

        public FactoryBuilder addField(String fieldName) {
            if (fieldName == null) {
                throw new NullPointerException("fieldName == null");
            }
            if ((fieldName = fieldName.trim()).isEmpty()) {
                throw new IllegalArgumentException("fieldName is empty");
            }
            this.fieldNames.add(fieldName.toLowerCase(Locale.ROOT));
            return this;
        }

        public FactoryBuilder addPrefixedFields(String prefix, Collection<String> fieldNames) {
            if (prefix == null) {
                throw new NullPointerException("prefix == null");
            }
            if (prefix.isEmpty()) {
                throw new IllegalArgumentException("prefix is empty");
            }
            if (fieldNames == null) {
                throw new NullPointerException("fieldNames == null");
            }
            this.prefixedNames.put(prefix, ExtraFieldPropagation.ensureLowerCase(fieldNames));
            return this;
        }

        public Factory build() {
            if (this.prefixedNames.isEmpty()) {
                String[] validated = ExtraFieldPropagation.ensureLowerCase(this.fieldNames);
                return new Factory(this.delegate, validated, validated);
            }
            ArrayList<String> fields = new ArrayList<String>();
            ArrayList<String> keys = new ArrayList<String>();
            if (!this.fieldNames.isEmpty()) {
                List<String> validated = Arrays.asList(ExtraFieldPropagation.ensureLowerCase(this.fieldNames));
                fields.addAll(validated);
                keys.addAll(validated);
            }
            for (Map.Entry<String, String[]> entry : this.prefixedNames.entrySet()) {
                String[] nextFieldNames;
                String nextPrefix = entry.getKey();
                for (String nextFieldName : nextFieldNames = entry.getValue()) {
                    fields.add(nextFieldName);
                    keys.add(nextPrefix + nextFieldName);
                }
            }
            return new Factory(this.delegate, fields.toArray(new String[0]), keys.toArray(new String[0]));
        }
    }
}

