/*
 * Decompiled with CFR 0.152.
 */
package brave.propagation;

import brave.internal.Nullable;
import brave.internal.WrappingExecutorService;
import brave.propagation.TraceContext;
import java.io.Closeable;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

public abstract class CurrentTraceContext {
    @Nullable
    public abstract TraceContext get();

    public abstract Scope newScope(@Nullable TraceContext var1);

    public <C> Callable<C> wrap(final Callable<C> task) {
        final TraceContext invocationContext = this.get();
        class CurrentTraceContextCallable
        implements Callable<C> {
            CurrentTraceContextCallable() {
            }

            @Override
            public C call() throws Exception {
                Scope scope = CurrentTraceContext.this.newScope(invocationContext);
                Throwable throwable = null;
                try {
                    Object v = task.call();
                    return v;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (scope != null) {
                        if (throwable != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable3) {
                            }
                        } else {
                            scope.close();
                        }
                    }
                }
            }
        }
        return new CurrentTraceContextCallable();
    }

    public Runnable wrap(final Runnable task) {
        final TraceContext invocationContext = this.get();
        class CurrentTraceContextRunnable
        implements Runnable {
            CurrentTraceContextRunnable() {
            }

            @Override
            public void run() {
                Scope scope = CurrentTraceContext.this.newScope(invocationContext);
                Throwable throwable = null;
                try {
                    task.run();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (scope != null) {
                        if (throwable != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable3) {
                            }
                        } else {
                            scope.close();
                        }
                    }
                }
            }
        }
        return new CurrentTraceContextRunnable();
    }

    public Executor executor(final Executor delegate) {
        class CurrentTraceContextExecutor
        implements Executor {
            CurrentTraceContextExecutor() {
            }

            @Override
            public void execute(Runnable task) {
                delegate.execute(CurrentTraceContext.this.wrap(task));
            }
        }
        return new CurrentTraceContextExecutor();
    }

    public ExecutorService executorService(final ExecutorService delegate) {
        class CurrentTraceContextExecutorService
        extends WrappingExecutorService {
            CurrentTraceContextExecutorService() {
            }

            @Override
            protected ExecutorService delegate() {
                return delegate;
            }

            @Override
            protected <C> Callable<C> wrap(Callable<C> task) {
                return CurrentTraceContext.this.wrap(task);
            }

            @Override
            protected Runnable wrap(Runnable task) {
                return CurrentTraceContext.this.wrap(task);
            }
        }
        return new CurrentTraceContextExecutorService();
    }

    public static final class Default
    extends CurrentTraceContext {
        static final ThreadLocal<TraceContext> DEFAULT = new ThreadLocal();
        static final InheritableThreadLocal<TraceContext> INHERITABLE = new InheritableThreadLocal();
        final ThreadLocal<TraceContext> local;

        @Deprecated
        public Default() {
            this(INHERITABLE);
        }

        public static CurrentTraceContext create() {
            return new Default(DEFAULT);
        }

        public static CurrentTraceContext inheritable() {
            return new Default(INHERITABLE);
        }

        Default(ThreadLocal<TraceContext> local) {
            if (local == null) {
                throw new NullPointerException("local == null");
            }
            this.local = local;
        }

        @Override
        public TraceContext get() {
            return this.local.get();
        }

        @Override
        public Scope newScope(@Nullable TraceContext currentSpan) {
            final TraceContext previous = this.local.get();
            this.local.set(currentSpan);
            class DefaultCurrentTraceContextScope
            implements Scope {
                DefaultCurrentTraceContextScope() {
                }

                @Override
                public void close() {
                    Default.this.local.set(previous);
                }
            }
            return new DefaultCurrentTraceContextScope();
        }
    }

    public static interface Scope
    extends Closeable {
        @Override
        public void close();
    }
}

