/*
 * Decompiled with CFR 0.152.
 */
package brave.propagation;

import brave.internal.HexCodec;
import brave.propagation.Propagation;
import brave.propagation.SamplingFlags;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class B3Propagation<K>
implements Propagation<K> {
    public static final Propagation.Factory FACTORY = new Propagation.Factory(){

        @Override
        public <K> Propagation<K> create(Propagation.KeyFactory<K> keyFactory) {
            return new B3Propagation<K>(keyFactory);
        }

        @Override
        public boolean supportsJoin() {
            return true;
        }

        public String toString() {
            return "B3PropagationFactory";
        }
    };
    static final String TRACE_ID_NAME = "X-B3-TraceId";
    static final String SPAN_ID_NAME = "X-B3-SpanId";
    static final String PARENT_SPAN_ID_NAME = "X-B3-ParentSpanId";
    static final String SAMPLED_NAME = "X-B3-Sampled";
    static final String FLAGS_NAME = "X-B3-Flags";
    final K traceIdKey;
    final K spanIdKey;
    final K parentSpanIdKey;
    final K sampledKey;
    final K debugKey;
    final List<K> fields;

    B3Propagation(Propagation.KeyFactory<K> keyFactory) {
        this.traceIdKey = keyFactory.create(TRACE_ID_NAME);
        this.spanIdKey = keyFactory.create(SPAN_ID_NAME);
        this.parentSpanIdKey = keyFactory.create(PARENT_SPAN_ID_NAME);
        this.sampledKey = keyFactory.create(SAMPLED_NAME);
        this.debugKey = keyFactory.create(FLAGS_NAME);
        this.fields = Collections.unmodifiableList(Arrays.asList(this.traceIdKey, this.spanIdKey, this.parentSpanIdKey, this.sampledKey, this.debugKey));
    }

    @Override
    public List<K> keys() {
        return this.fields;
    }

    @Override
    public <C> TraceContext.Injector<C> injector(Propagation.Setter<C, K> setter) {
        if (setter == null) {
            throw new NullPointerException("setter == null");
        }
        return new B3Injector<C, K>(this, setter);
    }

    @Override
    public <C> TraceContext.Extractor<C> extractor(Propagation.Getter<C, K> getter) {
        if (getter == null) {
            throw new NullPointerException("getter == null");
        }
        return new B3Extractor<C, K>(this, getter);
    }

    static final class B3Extractor<C, K>
    implements TraceContext.Extractor<C> {
        final B3Propagation<K> propagation;
        final Propagation.Getter<C, K> getter;

        B3Extractor(B3Propagation<K> propagation, Propagation.Getter<C, K> getter) {
            this.propagation = propagation;
            this.getter = getter;
        }

        @Override
        public TraceContextOrSamplingFlags extract(C carrier) {
            if (carrier == null) {
                throw new NullPointerException("carrier == null");
            }
            String traceId = this.getter.get(carrier, this.propagation.traceIdKey);
            String sampled = this.getter.get(carrier, this.propagation.sampledKey);
            String debug = this.getter.get(carrier, this.propagation.debugKey);
            if (traceId == null && sampled == null && debug == null) {
                return TraceContextOrSamplingFlags.EMPTY;
            }
            Boolean sampledV = sampled != null ? Boolean.valueOf(sampled.equals("1") || sampled.equalsIgnoreCase("true")) : null;
            boolean debugV = "1".equals(debug);
            String spanId = this.getter.get(carrier, this.propagation.spanIdKey);
            if (spanId == null) {
                return TraceContextOrSamplingFlags.create(debugV ? SamplingFlags.DEBUG : SamplingFlags.Builder.build(sampledV));
            }
            TraceContext.Builder result = TraceContext.newBuilder().sampled(sampledV).debug(debugV);
            result.traceIdHigh(traceId.length() == 32 ? HexCodec.lowerHexToUnsignedLong(traceId, 0) : 0L);
            result.traceId(HexCodec.lowerHexToUnsignedLong(traceId));
            result.spanId(HexCodec.lowerHexToUnsignedLong(spanId));
            String parentSpanIdString = this.getter.get(carrier, this.propagation.parentSpanIdKey);
            if (parentSpanIdString != null) {
                result.parentId(HexCodec.lowerHexToUnsignedLong(parentSpanIdString));
            }
            return TraceContextOrSamplingFlags.create(result.build());
        }
    }

    static final class B3Injector<C, K>
    implements TraceContext.Injector<C> {
        final B3Propagation<K> propagation;
        final Propagation.Setter<C, K> setter;

        B3Injector(B3Propagation<K> propagation, Propagation.Setter<C, K> setter) {
            this.propagation = propagation;
            this.setter = setter;
        }

        @Override
        public void inject(TraceContext traceContext, C carrier) {
            this.setter.put(carrier, this.propagation.traceIdKey, traceContext.traceIdString());
            this.setter.put(carrier, this.propagation.spanIdKey, HexCodec.toLowerHex(traceContext.spanId()));
            long parentId = traceContext.parentIdAsLong();
            if (parentId != 0L) {
                this.setter.put(carrier, this.propagation.parentSpanIdKey, HexCodec.toLowerHex(parentId));
            }
            if (traceContext.debug()) {
                this.setter.put(carrier, this.propagation.debugKey, "1");
            } else if (traceContext.sampled() != null) {
                this.setter.put(carrier, this.propagation.sampledKey, traceContext.sampled() != false ? "1" : "0");
            }
        }
    }
}

