/*
 * Decompiled with CFR 0.152.
 */
package brave;

import brave.Clock;
import brave.NoopSpan;
import brave.RealSpan;
import brave.Span;
import brave.Tracing;
import brave.internal.Nullable;
import brave.internal.Platform;
import brave.internal.recorder.Recorder;
import brave.propagation.CurrentTraceContext;
import brave.propagation.Propagation;
import brave.propagation.SamplingFlags;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import brave.propagation.TraceIdContext;
import brave.sampler.Sampler;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import zipkin.reporter.Reporter;
import zipkin2.Endpoint;

public final class Tracer {
    final Clock clock;
    final Propagation.Factory propagationFactory;
    final zipkin2.reporter.Reporter<zipkin2.Span> reporter;
    final Recorder recorder;
    final Sampler sampler;
    final CurrentTraceContext currentTraceContext;
    final boolean traceId128Bit;
    final boolean supportsJoin;
    final AtomicBoolean noop;

    @Deprecated
    public static Builder newBuilder() {
        return new Builder();
    }

    Tracer(Tracing.Builder builder, Clock clock, AtomicBoolean noop) {
        this.noop = noop;
        this.propagationFactory = builder.propagationFactory;
        this.supportsJoin = builder.supportsJoin && this.propagationFactory.supportsJoin();
        this.clock = clock;
        this.reporter = builder.reporter;
        this.recorder = new Recorder(builder.endpoint, clock, builder.reporter, this.noop);
        this.sampler = builder.sampler;
        this.currentTraceContext = builder.currentTraceContext;
        this.traceId128Bit = builder.traceId128Bit || this.propagationFactory.requires128BitTraceId();
    }

    @Deprecated
    public Clock clock() {
        return this.clock;
    }

    public Span newTrace() {
        return this.toSpan(this.newRootContext(SamplingFlags.EMPTY, Collections.<Object>emptyList()));
    }

    public final Span joinSpan(TraceContext context) {
        if (context == null) {
            throw new NullPointerException("context == null");
        }
        if (!this.supportsJoin) {
            return this.newChild(context);
        }
        if (context.sampled() == null) {
            context = context.toBuilder().sampled(this.sampler.isSampled(context.traceId())).build();
        } else if (context.sampled().booleanValue()) {
            this.recorder.setShared(context);
        }
        return this.toSpan(context);
    }

    public Span newChild(TraceContext parent) {
        if (parent == null) {
            throw new NullPointerException("parent == null");
        }
        return this.nextSpan(TraceContextOrSamplingFlags.create(parent));
    }

    public Span nextSpan(TraceContextOrSamplingFlags extracted) {
        TraceContext parent = extracted.context();
        if (extracted.samplingFlags() != null) {
            TraceContext implicitParent = this.currentTraceContext.get();
            if (implicitParent == null) {
                return this.toSpan(this.newRootContext(extracted.samplingFlags(), extracted.extra()));
            }
            parent = Tracer.appendExtra(implicitParent, extracted.extra());
        }
        long nextId = this.nextId();
        if (parent != null) {
            Boolean sampled = parent.sampled();
            if (sampled == null) {
                sampled = this.sampler.isSampled(parent.traceId());
            }
            return this.toSpan(parent.toBuilder().spanId(nextId).parentId(parent.spanId()).sampled(sampled).build());
        }
        TraceIdContext traceIdContext = extracted.traceIdContext();
        if (extracted.traceIdContext() != null) {
            Boolean sampled = traceIdContext.sampled();
            if (sampled == null) {
                sampled = this.sampler.isSampled(traceIdContext.traceId());
            }
            return this.toSpan(TraceContext.newBuilder().sampled(sampled).debug(traceIdContext.debug()).traceIdHigh(traceIdContext.traceIdHigh()).traceId(traceIdContext.traceId()).spanId(nextId).extra(extracted.extra()).build());
        }
        throw new AssertionError((Object)"should not reach here");
    }

    public Span newTrace(SamplingFlags samplingFlags) {
        return this.toSpan(this.newRootContext(samplingFlags, Collections.<Object>emptyList()));
    }

    public Span toSpan(TraceContext context) {
        if (context == null) {
            throw new NullPointerException("context == null");
        }
        TraceContext decorated = this.propagationFactory.decorate(context);
        if (!this.noop.get() && Boolean.TRUE.equals(decorated.sampled())) {
            return RealSpan.create(decorated, this.recorder);
        }
        return NoopSpan.create(decorated);
    }

    TraceContext newRootContext(SamplingFlags samplingFlags, List<Object> extra) {
        long nextId = this.nextId();
        Boolean sampled = samplingFlags.sampled();
        if (sampled == null) {
            sampled = this.sampler.isSampled(nextId);
        }
        return TraceContext.newBuilder().sampled(sampled).traceIdHigh(this.traceId128Bit ? Platform.get().nextTraceIdHigh() : 0L).traceId(nextId).spanId(nextId).debug(samplingFlags.debug()).extra(extra).build();
    }

    long nextId() {
        long nextId = Platform.get().randomLong();
        while (nextId == 0L) {
            nextId = Platform.get().randomLong();
        }
        return nextId;
    }

    public SpanInScope withSpanInScope(@Nullable Span span) {
        return new SpanInScope(this.currentTraceContext.newScope(span != null ? span.context() : null));
    }

    @Nullable
    public Span currentSpan() {
        TraceContext currentContext = this.currentTraceContext.get();
        return currentContext != null ? this.toSpan(currentContext) : null;
    }

    public Span nextSpan() {
        TraceContext parent = this.currentTraceContext.get();
        return parent == null ? this.newTrace() : this.newChild(parent);
    }

    public String toString() {
        TraceContext currentSpan = this.currentTraceContext.get();
        List<zipkin2.Span> inFlight = this.recorder.snapshot();
        return "Tracer{" + (currentSpan != null ? "currentSpan=" + currentSpan + ", " : "") + (inFlight.size() > 0 ? "inFlight=" + inFlight + ", " : "") + (this.noop.get() ? "noop=true, " : "") + "reporter=" + this.reporter + "}";
    }

    static TraceContext appendExtra(TraceContext context, List<Object> extra) {
        if (extra.isEmpty()) {
            return context;
        }
        if (context.extra().isEmpty()) {
            return context.toBuilder().extra(extra).build();
        }
        ArrayList<Object> merged = new ArrayList<Object>(context.extra());
        merged.addAll(extra);
        return context.toBuilder().extra(merged).build();
    }

    public static final class SpanInScope
    implements Closeable {
        final CurrentTraceContext.Scope scope;

        SpanInScope(CurrentTraceContext.Scope scope) {
            if (scope == null) {
                throw new NullPointerException("scope == null");
            }
            this.scope = scope;
        }

        @Override
        public void close() {
            this.scope.close();
        }

        public String toString() {
            return this.scope.toString();
        }
    }

    @Deprecated
    public static final class Builder {
        final Tracing.Builder delegate = new Tracing.Builder();

        public Builder localServiceName(String localServiceName) {
            this.delegate.localServiceName(localServiceName);
            return this;
        }

        @Deprecated
        public Builder localEndpoint(zipkin.Endpoint localEndpoint) {
            return this.endpoint(localEndpoint.toV2());
        }

        @Deprecated
        public Builder localEndpoint(Endpoint localEndpoint) {
            this.delegate.endpoint(localEndpoint);
            return this;
        }

        public Builder endpoint(Endpoint endpoint) {
            this.delegate.endpoint(endpoint);
            return this;
        }

        @Deprecated
        public Builder reporter(Reporter<zipkin.Span> reporter) {
            this.delegate.reporter(reporter);
            return this;
        }

        public Builder spanReporter(zipkin2.reporter.Reporter<zipkin2.Span> reporter) {
            this.delegate.spanReporter(reporter);
            return this;
        }

        public Builder clock(Clock clock) {
            this.delegate.clock(clock);
            return this;
        }

        public Builder sampler(Sampler sampler) {
            this.delegate.sampler(sampler);
            return this;
        }

        public Builder currentTraceContext(CurrentTraceContext currentTraceContext) {
            this.delegate.currentTraceContext(currentTraceContext);
            return this;
        }

        public Builder traceId128Bit(boolean traceId128Bit) {
            this.delegate.traceId128Bit(traceId128Bit);
            return this;
        }

        public Builder supportsJoin(boolean supportsJoin) {
            this.delegate.supportsJoin(supportsJoin);
            return this;
        }

        public Tracer build() {
            return this.delegate.build().tracer();
        }
    }
}

