/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport.impl.sender;

import io.zeebe.dispatcher.impl.log.DataFrameDescriptor;
import io.zeebe.transport.impl.RequestResponseHeaderDescriptor;
import io.zeebe.transport.impl.TransportHeaderDescriptor;
import io.zeebe.util.buffer.BufferWriter;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class TransportHeaderWriter {
    private static final int REQUEST_HEADER_LENGTH = DataFrameDescriptor.HEADER_LENGTH + TransportHeaderDescriptor.HEADER_LENGTH + RequestResponseHeaderDescriptor.HEADER_LENGTH;
    private static final int MESSAGE_HEADER_LENGTH = DataFrameDescriptor.HEADER_LENGTH + TransportHeaderDescriptor.HEADER_LENGTH;
    private static final int STREAM_ID_OFFSET = DataFrameDescriptor.STREAM_ID_OFFSET;
    private static final int REQUEST_ID_OFFSET = DataFrameDescriptor.HEADER_LENGTH + TransportHeaderDescriptor.HEADER_LENGTH + RequestResponseHeaderDescriptor.REQUEST_ID_OFFSET;
    private final UnsafeBuffer bufferView = new UnsafeBuffer();

    public static int getFramedRequestLength(int messageLength) {
        return DataFrameDescriptor.alignedLength((int)(REQUEST_HEADER_LENGTH + messageLength));
    }

    public static int getFramedMessageLength(int messageLength) {
        return DataFrameDescriptor.alignedLength((int)(MESSAGE_HEADER_LENGTH + messageLength));
    }

    public void wrapRequest(MutableDirectBuffer buffer, BufferWriter messageWriter) {
        this.bufferView.wrap((DirectBuffer)buffer);
        int fragmentLength = REQUEST_HEADER_LENGTH + messageWriter.getLength();
        this.bufferView.putInt(DataFrameDescriptor.FRAME_LENGTH_OFFSET, fragmentLength);
        this.bufferView.putShort(DataFrameDescriptor.TYPE_OFFSET, (short)0);
        this.bufferView.putShort(DataFrameDescriptor.HEADER_LENGTH + TransportHeaderDescriptor.PROTOCOL_ID_OFFSET, (short)0);
        messageWriter.write((MutableDirectBuffer)this.bufferView, REQUEST_HEADER_LENGTH);
    }

    public void wrapMessage(MutableDirectBuffer buffer, BufferWriter messageWriter, int remoteStreamId) {
        this.bufferView.wrap((DirectBuffer)buffer);
        int fragmentLength = MESSAGE_HEADER_LENGTH + messageWriter.getLength();
        this.bufferView.putInt(DataFrameDescriptor.FRAME_LENGTH_OFFSET, fragmentLength);
        this.bufferView.putShort(DataFrameDescriptor.TYPE_OFFSET, (short)0);
        this.bufferView.putInt(DataFrameDescriptor.STREAM_ID_OFFSET, remoteStreamId);
        this.bufferView.putShort(DataFrameDescriptor.HEADER_LENGTH + TransportHeaderDescriptor.PROTOCOL_ID_OFFSET, (short)1);
        messageWriter.write((MutableDirectBuffer)this.bufferView, MESSAGE_HEADER_LENGTH);
    }

    public TransportHeaderWriter setStreamId(int streamId) {
        this.bufferView.putInt(STREAM_ID_OFFSET, streamId);
        return this;
    }

    public TransportHeaderWriter setRequestId(long requestId) {
        this.bufferView.putLong(REQUEST_ID_OFFSET, requestId);
        return this;
    }
}

