/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport.impl.sender;

import io.zeebe.transport.ClientResponse;
import io.zeebe.transport.Loggers;
import io.zeebe.transport.RemoteAddress;
import io.zeebe.transport.RequestTimeoutException;
import io.zeebe.transport.impl.ClientResponseImpl;
import io.zeebe.transport.impl.IncomingResponse;
import io.zeebe.transport.impl.sender.TransportHeaderWriter;
import io.zeebe.util.sched.future.ActorFuture;
import io.zeebe.util.sched.future.CompletableActorFuture;
import java.time.Duration;
import java.util.Deque;
import java.util.LinkedList;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.slf4j.Logger;

public class OutgoingRequest {
    private static final Logger LOG = Loggers.TRANSPORT_LOGGER;
    private final TransportHeaderWriter headerWriter = new TransportHeaderWriter();
    private final ActorFuture<ClientResponse> responseFuture = new CompletableActorFuture();
    private final Supplier<RemoteAddress> remoteAddressSupplier;
    private final Predicate<DirectBuffer> retryPredicate;
    private final Duration timeout;
    private final Deque<RemoteAddress> remotesTried = new LinkedList<RemoteAddress>();
    private final MutableDirectBuffer requestBuffer;
    private long timerId = -1L;
    private long lastRequestId = -1L;
    private boolean isTimedout;

    public OutgoingRequest(Supplier<RemoteAddress> remoteAddressSupplier, Predicate<DirectBuffer> retryPredicate, UnsafeBuffer requestBuffer, Duration timeout) {
        this.remoteAddressSupplier = remoteAddressSupplier;
        this.retryPredicate = retryPredicate;
        this.requestBuffer = requestBuffer;
        this.timeout = timeout;
    }

    public ActorFuture<ClientResponse> getResponseFuture() {
        return this.responseFuture;
    }

    public RemoteAddress getNextRemoteAddress() {
        return this.remoteAddressSupplier.get();
    }

    public boolean tryComplete(IncomingResponse incomingResponse) {
        DirectBuffer data = incomingResponse.getResponseBuffer();
        if (this.responseFuture.isDone()) {
            return true;
        }
        if (!this.retryPredicate.test(data)) {
            try {
                RemoteAddress remoteAddress = this.remotesTried.peekFirst();
                ClientResponseImpl response = new ClientResponseImpl(incomingResponse, remoteAddress);
                this.responseFuture.complete((Object)response);
            }
            catch (Exception e) {
                LOG.debug("Could not complete request future", (Throwable)e);
            }
            return true;
        }
        return false;
    }

    public void fail(Throwable throwable) {
        try {
            this.responseFuture.completeExceptionally(throwable);
        }
        catch (Exception e) {
            LOG.debug("Could not complete request future exceptionally", (Throwable)e);
        }
    }

    public DirectBuffer getRequestBuffer() {
        return this.requestBuffer;
    }

    public RemoteAddress getCurrentRemoteAddress() {
        return this.remotesTried.peekFirst();
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public void markRemoteAddress(RemoteAddress remoteAddress) {
        if (!remoteAddress.equals(this.remotesTried.peekFirst())) {
            this.remotesTried.push(remoteAddress);
        }
    }

    public TransportHeaderWriter getHeaderWriter() {
        return this.headerWriter;
    }

    public boolean hasTimeoutScheduled() {
        return this.timerId != -1L;
    }

    public long getTimerId() {
        return this.timerId;
    }

    public void setTimerId(long timerId) {
        this.timerId = timerId;
    }

    public long getLastRequestId() {
        return this.lastRequestId;
    }

    public void setLastRequestId(long requestId) {
        this.lastRequestId = requestId;
    }

    public void timeout() {
        this.isTimedout = true;
        this.fail(new RequestTimeoutException("Request timed out after " + this.timeout));
    }

    public boolean isTimedout() {
        return this.isTimedout;
    }
}

