/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport.impl.selector;

import io.zeebe.transport.Loggers;
import io.zeebe.transport.impl.TransportChannel;
import io.zeebe.util.sched.ActorControl;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.util.ArrayList;
import java.util.List;
import java.util.function.ToIntFunction;
import org.agrona.LangUtil;
import org.agrona.nio.TransportPoller;
import org.slf4j.Logger;

public class ReadTransportPoller
extends TransportPoller {
    private static final Logger LOG = Loggers.TRANSPORT_LOGGER;
    protected final List<TransportChannel> channels = new ArrayList<TransportChannel>();
    protected final List<TransportChannel> channelsToAdd = new ArrayList<TransportChannel>();
    protected final ToIntFunction<SelectionKey> processKeyFn = this::processKey;
    private final ActorControl actor;
    protected final Runnable pollNow = this::pollNow;

    public ReadTransportPoller(ActorControl actor) {
        this.actor = actor;
    }

    public void pollBlocking() {
        if (this.selector.isOpen()) {
            try {
                this.selector.select();
            }
            catch (IOException e) {
                this.selectedKeySet.reset();
                throw new RuntimeException(e);
            }
        }
    }

    public void pollBlockingEnded(Throwable t) {
        this.maintainChannels();
        this.processKeys();
        this.actor.runUntilDone(this.pollNow);
    }

    public void pollNow() {
        int workCount = 0;
        if (this.channels.size() <= 5) {
            for (int i = 0; i < this.channels.size(); ++i) {
                TransportChannel channel = this.channels.get(i);
                workCount += channel.receive();
            }
        } else {
            try {
                this.selector.selectNow();
                workCount += this.processKeys();
            }
            catch (IOException e) {
                this.selectedKeySet.reset();
                LangUtil.rethrowUnchecked((Throwable)e);
            }
        }
        if (workCount == 0) {
            this.actor.done();
            this.actor.runBlocking(this::pollBlocking, this::pollBlockingEnded);
        } else {
            this.actor.yield();
        }
    }

    private void maintainChannels() {
        for (int i = 0; i < this.channelsToAdd.size(); ++i) {
            TransportChannel channel = this.channelsToAdd.get(i);
            try {
                channel.registerSelector(this.selector, 1);
                this.channels.add(channel);
                continue;
            }
            catch (Exception e) {
                LOG.debug("Failed to add channel {}", (Object)channel, (Object)e);
            }
        }
        this.channelsToAdd.clear();
    }

    public int processKeys() {
        return this.selectedKeySet.forEach(this.processKeyFn);
    }

    protected int processKey(SelectionKey key) {
        int workCount = 0;
        if (key != null && key.isValid()) {
            TransportChannel channel = (TransportChannel)key.attachment();
            workCount = channel.receive();
        }
        return workCount;
    }

    public void addChannel(TransportChannel channel) {
        this.channelsToAdd.add(channel);
        this.selector.wakeup();
    }

    public void removeChannel(TransportChannel channel) {
        this.channels.remove(channel);
    }

    public void clearChannels() {
        this.channels.clear();
    }
}

