/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport.impl.selector;

import io.zeebe.transport.impl.TransportChannel;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.util.ArrayList;
import java.util.List;
import java.util.function.ToIntFunction;
import org.agrona.nio.TransportPoller;

public class ConnectTransportPoller
extends TransportPoller {
    protected final List<TransportChannel> channelsToAdd = new ArrayList<TransportChannel>();
    protected final List<TransportChannel> channelsToRemove = new ArrayList<TransportChannel>();
    protected final ToIntFunction<SelectionKey> processKeyFn = this::processKey;

    public void pollBlocking() {
        if (this.selector.isOpen()) {
            try {
                this.selector.select();
            }
            catch (IOException e) {
                this.selectedKeySet.reset();
                throw new RuntimeException(e);
            }
        }
    }

    public void processKeys() {
        this.selectedKeySet.forEach(this.processKeyFn);
        if (this.selector.isOpen()) {
            for (TransportChannel channel : this.channelsToAdd) {
                channel.registerSelector(this.selector, 8);
            }
            for (TransportChannel channel : this.channelsToRemove) {
                channel.removeSelector(this.selector);
            }
        }
        this.channelsToAdd.clear();
        this.channelsToRemove.clear();
    }

    protected int processKey(SelectionKey key) {
        if (key != null && key.isValid()) {
            TransportChannel channel = (TransportChannel)key.attachment();
            this.removeChannel(channel);
            channel.finishConnect();
            return 1;
        }
        return 0;
    }

    public void addChannel(TransportChannel channel) {
        this.channelsToAdd.add(channel);
        this.selector.wakeup();
    }

    public void removeChannel(TransportChannel channel) {
        this.channelsToRemove.add(channel);
        this.selector.wakeup();
    }
}

