/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport.impl.actor;

import io.zeebe.transport.impl.TransportChannel;
import io.zeebe.transport.impl.TransportContext;
import io.zeebe.transport.impl.actor.ActorContext;
import io.zeebe.transport.impl.selector.ReadTransportPoller;
import io.zeebe.util.sched.Actor;
import io.zeebe.util.sched.future.ActorFuture;

public class Receiver
extends Actor {
    protected final ReadTransportPoller transportPoller;
    private String name;

    public Receiver(ActorContext actorContext, TransportContext context) {
        this.transportPoller = new ReadTransportPoller(this.actor);
        this.name = String.format("%s-receiver", context.getName());
        actorContext.setReceiver(this);
    }

    public String getName() {
        return this.name;
    }

    protected void onActorStarted() {
        this.actor.runBlocking(this.transportPoller::pollBlocking, this.transportPoller::pollBlockingEnded);
    }

    protected void onActorClosing() {
        this.transportPoller.close();
        this.transportPoller.clearChannels();
    }

    public ActorFuture<Void> removeChannel(TransportChannel c) {
        return this.actor.call(() -> this.transportPoller.removeChannel(c));
    }

    public ActorFuture<Void> registerChannel(TransportChannel c) {
        return this.actor.call(() -> this.transportPoller.addChannel(c));
    }

    public ActorFuture<Void> close() {
        return this.actor.close();
    }
}

