/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport.impl.actor;

import io.zeebe.transport.Loggers;
import io.zeebe.transport.TransportListener;
import io.zeebe.transport.impl.RemoteAddressListImpl;
import io.zeebe.transport.impl.TransportChannel;
import io.zeebe.transport.impl.TransportChannelFactory;
import io.zeebe.transport.impl.TransportContext;
import io.zeebe.transport.impl.actor.ActorContext;
import io.zeebe.util.sched.Actor;
import io.zeebe.util.sched.ActorThread;
import io.zeebe.util.sched.future.ActorFuture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.agrona.collections.Int2ObjectHashMap;
import org.slf4j.Logger;

public abstract class Conductor
extends Actor
implements TransportChannel.ChannelLifecycleListener {
    private static final Logger LOG = Loggers.TRANSPORT_LOGGER;
    protected final RemoteAddressListImpl remoteAddressList;
    protected final TransportContext transportContext;
    protected final AtomicBoolean closing = new AtomicBoolean(false);
    protected final TransportChannelFactory channelFactory;
    private final List<TransportListener> transportListeners = new ArrayList<TransportListener>();
    private final ActorContext actorContext;
    protected Int2ObjectHashMap<TransportChannel> channels = new Int2ObjectHashMap();

    public Conductor(ActorContext actorContext, TransportContext context) {
        this.actorContext = actorContext;
        this.transportContext = context;
        this.remoteAddressList = context.getRemoteAddressList();
        this.channelFactory = context.getChannelFactory();
        actorContext.setConductor(this);
    }

    public ActorFuture<Void> registerListener(TransportListener channelListener) {
        return this.actor.call(() -> this.transportListeners.add(channelListener));
    }

    public void removeListener(TransportListener channelListener) {
        if (ActorThread.current() != null) {
            this.actor.submit(() -> this.transportListeners.remove(channelListener));
        } else {
            this.actor.call(() -> this.transportListeners.remove(channelListener));
        }
    }

    @Override
    public void onChannelConnected(TransportChannel ch) {
        this.channels.put(ch.getRemoteAddress().getStreamId(), (Object)ch);
        ActorFuture<Void> f1 = this.actorContext.getReceiver().registerChannel(ch);
        ActorFuture<Void> f2 = this.actorContext.getSender().onChannelConnected(ch);
        this.actor.runOnCompletion(Arrays.asList(f1, f2), t -> this.transportListeners.forEach(l -> {
            try {
                l.onConnectionEstablished(ch.getRemoteAddress());
            }
            catch (Exception e) {
                LOG.debug("Failed to call transport listener {} on channel connect", l, (Object)e);
            }
        }));
    }

    @Override
    public void onChannelClosed(TransportChannel ch, boolean wasConnected) {
        this.actor.run(() -> {
            if (this.channels.remove(ch.getRemoteAddress().getStreamId()) != null && wasConnected) {
                this.failRequestsOnChannel(ch, "Socket channel has been disconnected");
                ActorFuture<Void> f1 = this.actorContext.getReceiver().removeChannel(ch);
                ActorFuture<Void> f2 = this.actorContext.getSender().onChannelClosed(ch);
                this.actor.runOnCompletion(Arrays.asList(f1, f2), t -> this.transportListeners.forEach(l -> {
                    try {
                        l.onConnectionClosed(ch.getRemoteAddress());
                    }
                    catch (Exception e) {
                        LOG.debug("Failed to call transport listener {} on disconnect", l, (Object)e);
                    }
                }));
            }
        });
    }

    public ActorFuture<Void> interruptAllChannels() {
        return this.actor.call(() -> new ArrayList<TransportChannel>((Collection<TransportChannel>)this.channels.values()).forEach(TransportChannel::interrupt));
    }

    protected void failRequestsOnChannel(TransportChannel ch, String reason) {
        this.actorContext.getSender().failPendingRequestsToRemote(ch.getRemoteAddress(), reason);
    }

    protected void onActorClosing() {
        this.remoteAddressList.deactivateAll();
        new ArrayList<TransportChannel>((Collection<TransportChannel>)this.channels.values()).forEach(TransportChannel::close);
        ActorFuture<Void> senderClose = this.actorContext.closeSender();
        ActorFuture<Void> receiverClose = this.actorContext.closeReceiver();
        this.actor.runOnCompletion(Arrays.asList(senderClose, receiverClose), t -> this.onSenderAndReceiverClosed());
    }

    protected void onSenderAndReceiverClosed() {
    }

    public ActorFuture<Void> close() {
        return this.actor.close();
    }

    public ActorFuture<Void> closeCurrentChannels() {
        return this.actor.call(() -> new ArrayList<TransportChannel>((Collection<TransportChannel>)this.channels.values()).forEach(TransportChannel::close));
    }
}

