/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport.impl.actor;

import io.zeebe.dispatcher.Subscription;
import io.zeebe.transport.ClientInputMessageSubscription;
import io.zeebe.transport.ClientMessageHandler;
import io.zeebe.transport.ClientOutput;
import io.zeebe.transport.RemoteAddressList;
import io.zeebe.transport.impl.ClientInputMessageSubscriptionImpl;
import io.zeebe.transport.impl.RemoteAddressImpl;
import io.zeebe.transport.impl.TransportChannel;
import io.zeebe.transport.impl.TransportContext;
import io.zeebe.transport.impl.actor.ActorContext;
import io.zeebe.transport.impl.actor.Conductor;
import io.zeebe.transport.impl.selector.ConnectTransportPoller;
import io.zeebe.util.sched.future.ActorFuture;
import io.zeebe.util.sched.future.CompletableActorFuture;
import java.time.Duration;

public class ClientConductor
extends Conductor {
    private final ConnectTransportPoller connectTransportPoller = new ConnectTransportPoller();

    public ClientConductor(ActorContext actorContext, TransportContext context) {
        super(actorContext, context);
        this.remoteAddressList.setOnAddressAddedConsumer(this::onRemoteAddressAdded);
    }

    protected void onActorStarted() {
        super.onActorStarted();
        this.actor.pollBlocking(this.connectTransportPoller::pollBlocking, this.connectTransportPoller::processKeys);
    }

    public void openChannel(RemoteAddressImpl address, int connectAttempt) {
        TransportChannel channel = this.channelFactory.buildClientChannel(this, address, this.transportContext.getMessageMaxLength(), this.transportContext.getReceiveHandler());
        if (channel.beginConnect(connectAttempt)) {
            this.actor.runDelayed(Duration.ofMillis(Math.min(1000, 50 * connectAttempt)), () -> this.connectTransportPoller.addChannel(channel));
            this.channels.put(address.getStreamId(), (Object)channel);
        }
    }

    @Override
    public void onChannelClosed(TransportChannel channel, boolean wasConnected) {
        this.actor.submit(() -> {
            RemoteAddressImpl remoteAddress = channel.getRemoteAddress();
            if (remoteAddress.isActive()) {
                int openAttempt = channel.getOpenAttempt() + 1;
                this.openChannel(remoteAddress, openAttempt);
            }
            super.onChannelClosed(channel, wasConnected);
        });
    }

    @Override
    protected void onActorClosing() {
        this.connectTransportPoller.close();
        super.onActorClosing();
    }

    private void onRemoteAddressAdded(RemoteAddressImpl remoteAddress) {
        this.actor.call(() -> {
            TransportChannel channel = (TransportChannel)this.channels.get(remoteAddress.getStreamId());
            if (channel == null) {
                this.openChannel(remoteAddress, 0);
            } else if (channel.isClosed()) {
                this.openChannel(remoteAddress, 0);
            }
        });
    }

    public ActorFuture<ClientInputMessageSubscription> openClientInputMessageSubscription(String subscriptionName, ClientMessageHandler messageHandler, ClientOutput output, RemoteAddressList remoteAddressList) {
        CompletableActorFuture future = new CompletableActorFuture();
        this.actor.call(() -> {
            ActorFuture subscriptionFuture = this.transportContext.getReceiveBuffer().openSubscriptionAsync(subscriptionName);
            this.actor.runOnCompletion(subscriptionFuture, (s, t) -> {
                if (t != null) {
                    future.completeExceptionally(t);
                } else {
                    future.complete((Object)new ClientInputMessageSubscriptionImpl((Subscription)s, messageHandler, output, remoteAddressList));
                }
            });
        });
        return future;
    }
}

