/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport.impl;

import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class TransportHeaderDescriptor {
    public static final short REQUEST_RESPONSE = 0;
    public static final short FULL_DUPLEX_SINGLE_MESSAGE = 1;
    public static final short CONTROL_MESSAGE = 2;
    public static final int PROTOCOL_ID_OFFSET;
    public static final int HEADER_LENGTH;
    public static final ByteOrder HEADER_BYTE_ORDER;
    protected final UnsafeBuffer buffer = new UnsafeBuffer(0L, 0);

    public static int framedLength(int messageLength) {
        return HEADER_LENGTH + messageLength;
    }

    public static int headerLength() {
        return HEADER_LENGTH;
    }

    public static int protocolIdOffset(int offset) {
        return offset + PROTOCOL_ID_OFFSET;
    }

    public TransportHeaderDescriptor wrap(DirectBuffer buffer, int offset) {
        this.buffer.wrap(buffer, offset, HEADER_LENGTH);
        return this;
    }

    public TransportHeaderDescriptor protocolId(short protocolId) {
        this.buffer.putShort(PROTOCOL_ID_OFFSET, protocolId, HEADER_BYTE_ORDER);
        return this;
    }

    public TransportHeaderDescriptor putProtocolSingleMessage() {
        return this.protocolId((short)1);
    }

    public TransportHeaderDescriptor putProtocolRequestReponse() {
        return this.protocolId((short)0);
    }

    public int protocolId() {
        return this.buffer.getShort(PROTOCOL_ID_OFFSET, HEADER_BYTE_ORDER);
    }

    static {
        int offset;
        HEADER_BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
        PROTOCOL_ID_OFFSET = offset = 0;
        HEADER_LENGTH = offset += 2;
    }
}

