/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport.impl;

import io.zeebe.dispatcher.FragmentHandler;
import io.zeebe.dispatcher.impl.log.DataFrameDescriptor;
import io.zeebe.transport.Loggers;
import io.zeebe.transport.impl.RemoteAddressImpl;
import io.zeebe.util.ZbLogger;
import io.zeebe.util.allocation.AllocatedBuffer;
import io.zeebe.util.allocation.BufferAllocators;
import java.io.IOException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.agrona.DirectBuffer;
import org.agrona.LangUtil;
import org.agrona.concurrent.UnsafeBuffer;

public class TransportChannel {
    private static final ZbLogger LOG = Loggers.TRANSPORT_LOGGER;
    private static final AtomicIntegerFieldUpdater<TransportChannel> STATE_FIELD = AtomicIntegerFieldUpdater.newUpdater(TransportChannel.class, "state");
    private static final int CLOSED = 1;
    private static final int CONNECTING = 2;
    private static final int CONNECTED = 3;
    private final RemoteAddressImpl remoteAddress;
    private final AllocatedBuffer allocatedBuffer;
    private final ByteBuffer channelReadBuffer;
    private final UnsafeBuffer channelReadBufferView;
    private final ChannelLifecycleListener listener;
    private final FragmentHandler readHandler;
    private volatile int state = 1;
    private SocketChannel media;
    private int connectAttempt;
    private List<SelectionKey> registeredKeys = Collections.synchronizedList(new ArrayList());

    public TransportChannel(ChannelLifecycleListener listener, RemoteAddressImpl remoteAddress, int maxMessageSize, FragmentHandler readHandler) {
        this.listener = listener;
        this.remoteAddress = remoteAddress;
        this.readHandler = readHandler;
        this.allocatedBuffer = BufferAllocators.allocateDirect((int)(2 * maxMessageSize));
        this.channelReadBuffer = this.allocatedBuffer.getRawBuffer();
        this.channelReadBufferView = new UnsafeBuffer(this.channelReadBuffer);
    }

    public TransportChannel(ChannelLifecycleListener listener, RemoteAddressImpl remoteAddress, int maxMessageSize, FragmentHandler readHandler, SocketChannel media) {
        this(listener, remoteAddress, maxMessageSize, readHandler);
        this.media = media;
        STATE_FIELD.set(this, 3);
    }

    public int receive() {
        int workCount = 0;
        int received = this.mediaReceive(this.media, this.channelReadBuffer);
        LOG.trace("Received {} bytes on channel {}", received, (Object)this);
        if (received < 0) {
            this.doClose();
            return workCount;
        }
        int available = this.channelReadBuffer.position();
        LOG.trace("Channel read buffer has {} bytes available", available);
        int remaining = available;
        int offset = 0;
        while (remaining >= DataFrameDescriptor.HEADER_LENGTH) {
            boolean handled;
            ++workCount;
            int framedLength = this.channelReadBufferView.getInt(DataFrameDescriptor.lengthOffset((int)offset));
            int msgLength = DataFrameDescriptor.messageLength((int)framedLength);
            int msgOffset = DataFrameDescriptor.messageOffset((int)offset);
            int frameLength = DataFrameDescriptor.alignedLength((int)framedLength);
            if (remaining < frameLength || !(handled = this.handleMessage((DirectBuffer)this.channelReadBufferView, msgOffset, msgLength))) break;
            LOG.trace("Handler has handled message of {} bytes", framedLength);
            remaining -= frameLength;
            offset += frameLength;
        }
        if (offset > 0) {
            this.channelReadBuffer.limit(available);
            this.channelReadBuffer.position(offset);
            this.channelReadBuffer.compact();
        }
        return workCount;
    }

    private boolean handleMessage(DirectBuffer buffer, int msgOffset, int msgLength) {
        try {
            return this.readHandler.onFragment(buffer, msgOffset, msgLength, this.getStreamId(), false) != 1;
        }
        catch (Exception e) {
            LOG.trace("Failed to handle message", (Throwable)e);
            return true;
        }
    }

    private int mediaReceive(SocketChannel media, ByteBuffer receiveBuffer) {
        int bytesReceived = -2;
        try {
            bytesReceived = media.read(receiveBuffer);
        }
        catch (IOException e) {
            this.doClose();
        }
        return bytesReceived;
    }

    public int write(ByteBuffer buffer) {
        int bytesWritten = -1;
        try {
            bytesWritten = this.media.write(buffer);
        }
        catch (IOException e) {
            this.doClose();
        }
        return bytesWritten;
    }

    public int getStreamId() {
        return this.remoteAddress.getStreamId();
    }

    public void registerSelector(Selector selector, int ops) {
        try {
            SelectionKey key = this.media.register(selector, ops);
            key.attach(this);
            this.registeredKeys.add(key);
        }
        catch (ClosedChannelException e) {
            LangUtil.rethrowUnchecked((Throwable)e);
        }
    }

    public void removeSelector(Selector selector) {
        SelectionKey key = this.media.keyFor(selector);
        if (key != null) {
            key.cancel();
            this.registeredKeys.remove(key);
        }
    }

    public boolean beginConnect(int attempt) {
        if (STATE_FIELD.compareAndSet(this, 1, 2)) {
            this.connectAttempt = attempt;
            try {
                this.media = SocketChannel.open();
                this.media.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)true);
                this.media.configureBlocking(false);
                this.media.connect(this.remoteAddress.getAddress().toInetSocketAddress());
                return true;
            }
            catch (Exception e) {
                LOG.trace("Failed to begin connect to {}", (Object)this.remoteAddress, (Object)e);
                this.doClose();
                return false;
            }
        }
        return false;
    }

    public void finishConnect() {
        try {
            this.media.finishConnect();
            if (STATE_FIELD.compareAndSet(this, 2, 3)) {
                this.listener.onChannelConnected(this);
            }
            this.connectAttempt = 0;
        }
        catch (IOException e) {
            LOG.trace("Failed to finish connect to {}", (Object)this.remoteAddress, (Object)e);
            this.doClose();
        }
    }

    public boolean isClosed() {
        return STATE_FIELD.get(this) == 1;
    }

    public boolean isConnecting() {
        return STATE_FIELD.get(this) == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doClose() {
        block13: {
            boolean wasConnected;
            try {
                if (this.media != null) {
                    try {
                        List<SelectionKey> list = this.registeredKeys;
                        synchronized (list) {
                            this.registeredKeys.forEach(k -> k.cancel());
                            this.registeredKeys.clear();
                        }
                    }
                    finally {
                        this.media.close();
                    }
                }
                this.allocatedBuffer.close();
                int previousState = STATE_FIELD.getAndSet(this, 1);
                if (previousState == 1 || this.listener == null) break block13;
                wasConnected = previousState == 3;
            }
            catch (Exception e) {
                boolean wasConnected2;
                try {
                    LOG.debug("Failed to close channel", (Throwable)e);
                    int previousState = STATE_FIELD.getAndSet(this, 1);
                    if (previousState == 1 || this.listener == null) break block13;
                    wasConnected2 = previousState == 3;
                }
                catch (Throwable throwable) {
                    int previousState = STATE_FIELD.getAndSet(this, 1);
                    if (previousState != 1 && this.listener != null) {
                        boolean wasConnected3 = previousState == 3;
                        this.listener.onChannelClosed(this, wasConnected3);
                    }
                    throw throwable;
                }
                this.listener.onChannelClosed(this, wasConnected2);
            }
            this.listener.onChannelClosed(this, wasConnected);
        }
    }

    public RemoteAddressImpl getRemoteAddress() {
        return this.remoteAddress;
    }

    public void interrupt() {
        this.doClose();
    }

    public void close() {
        this.doClose();
    }

    public SocketChannel getNioChannel() {
        return this.media;
    }

    public int getOpenAttempt() {
        return this.connectAttempt;
    }

    public String toString() {
        return this.media != null ? this.media.toString() : "unconnected channel to remote " + this.remoteAddress;
    }

    public static interface ChannelLifecycleListener {
        public void onChannelConnected(TransportChannel var1);

        public void onChannelClosed(TransportChannel var1, boolean var2);
    }
}

