/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport.impl;

import io.zeebe.transport.RemoteAddress;
import io.zeebe.transport.RemoteAddressList;
import io.zeebe.transport.SocketAddress;
import io.zeebe.transport.impl.RemoteAddressImpl;
import java.util.function.Consumer;

public class RemoteAddressListImpl
implements RemoteAddressList {
    private volatile int size;
    private RemoteAddressImpl[] index = new RemoteAddressImpl[0];
    private Consumer<RemoteAddressImpl> onAddressAddedConsumer = r -> {};

    @Override
    public synchronized RemoteAddressImpl getByStreamId(int streamId) {
        if (streamId < this.size) {
            return this.index[streamId];
        }
        return null;
    }

    @Override
    public RemoteAddressImpl getByAddress(SocketAddress inetSocketAddress) {
        return this.getByAddress(inetSocketAddress, 1);
    }

    @Override
    public synchronized void retire(RemoteAddress remote) {
        this.getByStreamId(remote.getStreamId()).retire();
    }

    @Override
    public synchronized void deactivate(RemoteAddress remote) {
        this.getByStreamId(remote.getStreamId()).deactivate();
    }

    @Override
    public synchronized void deactivateAll() {
        for (int i = 0; i < this.size; ++i) {
            this.index[i].deactivate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteAddressImpl register(SocketAddress inetSocketAddress) {
        RemoteAddressImpl result = this.getByAddress(inetSocketAddress);
        if (result == null) {
            RemoteAddressListImpl remoteAddressListImpl = this;
            synchronized (remoteAddressListImpl) {
                result = this.getByAddress(inetSocketAddress, 3);
                if (result == null) {
                    int prevSize = this.size;
                    int newSize = prevSize + 1;
                    RemoteAddressImpl remoteAddress = new RemoteAddressImpl(prevSize, new SocketAddress(inetSocketAddress));
                    RemoteAddressImpl[] newAddresses = new RemoteAddressImpl[newSize];
                    System.arraycopy(this.index, 0, newAddresses, 0, prevSize);
                    newAddresses[remoteAddress.getStreamId()] = remoteAddress;
                    this.index = newAddresses;
                    this.size = newSize;
                    result = remoteAddress;
                } else if (result.isInAnyState(2)) {
                    result.activate();
                }
                this.onAddressAddedConsumer.accept(result);
            }
        }
        return result;
    }

    private synchronized RemoteAddressImpl getByAddress(SocketAddress inetSocketAddress, int stateMask) {
        int currSize = this.size;
        for (int i = 0; i < currSize; ++i) {
            RemoteAddressImpl remoteAddress = this.index[i];
            if (remoteAddress == null || !remoteAddress.getAddress().equals(inetSocketAddress) || !remoteAddress.isInAnyState(stateMask)) continue;
            return remoteAddress;
        }
        return null;
    }

    public synchronized void setOnAddressAddedConsumer(Consumer<RemoteAddressImpl> onAddressAddedConsumer) {
        this.onAddressAddedConsumer = onAddressAddedConsumer;
    }
}

