/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport.impl;

import io.zeebe.transport.RemoteAddress;
import io.zeebe.transport.SocketAddress;

public class RemoteAddressImpl
implements RemoteAddress {
    public static final int STATE_ACTIVE = 1;
    public static final int STATE_INACTIVE = 2;
    public static final int STATE_RETIRED = 4;
    private final int streamId;
    private final SocketAddress addr;
    private volatile int state;

    public RemoteAddressImpl(int streamId, SocketAddress addr) {
        this.streamId = streamId;
        this.addr = addr;
        this.state = 1;
    }

    @Override
    public int getStreamId() {
        return this.streamId;
    }

    @Override
    public SocketAddress getAddress() {
        return this.addr;
    }

    public void deactivate() {
        this.state = 2;
    }

    public void retire() {
        this.state = 4;
    }

    public void activate() {
        this.state = 1;
    }

    public boolean isInAnyState(int mask) {
        return (this.state & mask) != 0;
    }

    public boolean isActive() {
        return this.isInAnyState(1);
    }

    public String toString() {
        return "RemoteAddress{streamId=" + this.streamId + ", addr=" + this.addr + '}';
    }
}

