/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport.impl;

import io.zeebe.dispatcher.Dispatcher;
import io.zeebe.dispatcher.FragmentHandler;
import io.zeebe.transport.impl.TransportHeaderDescriptor;
import org.agrona.DirectBuffer;

public class ReceiveBufferHandler
implements FragmentHandler {
    protected final Dispatcher receiveBuffer;
    private final TransportHeaderDescriptor transportHeaderDescriptor = new TransportHeaderDescriptor();

    public ReceiveBufferHandler(Dispatcher receiveBuffer) {
        this.receiveBuffer = receiveBuffer;
    }

    public int onFragment(DirectBuffer buffer, int offset, int length, int streamId, boolean isMarkedFailed) {
        if (this.receiveBuffer == null) {
            return 0;
        }
        if (!isMarkedFailed) {
            this.transportHeaderDescriptor.wrap(buffer, offset);
            if (this.transportHeaderDescriptor.protocolId() == 2) {
                return 0;
            }
            long offerPosition = this.receiveBuffer.offer(buffer, offset, length, streamId);
            if (offerPosition < 0L) {
                return 1;
            }
            return 0;
        }
        return 0;
    }
}

