/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport;

import io.zeebe.dispatcher.Dispatcher;
import io.zeebe.dispatcher.FragmentHandler;
import io.zeebe.transport.BufferingServerTransport;
import io.zeebe.transport.ServerControlMessageListener;
import io.zeebe.transport.ServerMessageHandler;
import io.zeebe.transport.ServerOutput;
import io.zeebe.transport.ServerRequestHandler;
import io.zeebe.transport.ServerTransport;
import io.zeebe.transport.impl.DefaultChannelFactory;
import io.zeebe.transport.impl.ReceiveBufferHandler;
import io.zeebe.transport.impl.RemoteAddressListImpl;
import io.zeebe.transport.impl.ServerOutputImpl;
import io.zeebe.transport.impl.ServerReceiveHandler;
import io.zeebe.transport.impl.ServerSocketBinding;
import io.zeebe.transport.impl.TransportContext;
import io.zeebe.transport.impl.actor.Receiver;
import io.zeebe.transport.impl.actor.ServerActorContext;
import io.zeebe.transport.impl.actor.ServerConductor;
import io.zeebe.transport.impl.memory.NonBlockingMemoryPool;
import io.zeebe.transport.impl.memory.TransportMemoryPool;
import io.zeebe.transport.impl.sender.Sender;
import io.zeebe.util.ByteValue;
import io.zeebe.util.sched.Actor;
import io.zeebe.util.sched.ActorScheduler;
import java.net.InetSocketAddress;
import java.util.Objects;

public class ServerTransportBuilder {
    public static final int DEFAULT_MAX_MESSAGE_LENGTH = 524288;
    protected FragmentHandler receiveHandler;
    protected RemoteAddressListImpl remoteAddressList;
    protected ServerControlMessageListener controlMessageListener;
    private int messageMaxLength = 524288;
    private String name = "server";
    private ServerOutput output;
    private ActorScheduler scheduler;
    private InetSocketAddress bindAddress;
    private TransportMemoryPool messageMemoryPool = new NonBlockingMemoryPool(ByteValue.ofMegabytes((long)4L));

    public ServerTransportBuilder name(String name) {
        this.name = name;
        return this;
    }

    public ServerTransportBuilder messageMemoryPool(TransportMemoryPool messageMemoryPool) {
        this.messageMemoryPool = messageMemoryPool;
        return this;
    }

    public ServerTransportBuilder bindAddress(InetSocketAddress address) {
        this.bindAddress = address;
        return this;
    }

    public ServerTransportBuilder scheduler(ActorScheduler scheduler) {
        this.scheduler = scheduler;
        return this;
    }

    public ServerTransportBuilder messageMaxLength(int messageMaxLength) {
        this.messageMaxLength = messageMaxLength;
        return this;
    }

    protected ServerTransportBuilder receiveHandler(FragmentHandler receiveHandler) {
        this.receiveHandler = receiveHandler;
        return this;
    }

    public ServerTransportBuilder controlMessageListener(ServerControlMessageListener controlMessageListener) {
        this.controlMessageListener = controlMessageListener;
        return this;
    }

    public ServerTransport build(ServerMessageHandler messageHandler, ServerRequestHandler requestHandler) {
        this.remoteAddressList = new RemoteAddressListImpl();
        ServerActorContext actorContext = new ServerActorContext();
        Sender sender = new Sender(actorContext, this.messageMemoryPool, null, null);
        this.output = new ServerOutputImpl(sender);
        this.receiveHandler(new ServerReceiveHandler(this.output, this.remoteAddressList, messageHandler, requestHandler, this.controlMessageListener));
        this.validate();
        TransportContext context = this.buildTransportContext();
        this.buildActors(context, actorContext);
        return new ServerTransport(actorContext, context);
    }

    public BufferingServerTransport buildBuffering(Dispatcher receiveBuffer) {
        this.remoteAddressList = new RemoteAddressListImpl();
        this.receiveHandler(new ReceiveBufferHandler(receiveBuffer));
        this.validate();
        ServerActorContext actorContext = new ServerActorContext();
        Sender sender = new Sender(actorContext, this.messageMemoryPool, null, null);
        this.output = new ServerOutputImpl(sender);
        TransportContext context = this.buildTransportContext();
        context.setReceiveBuffer(receiveBuffer);
        this.buildActors(context, actorContext);
        return new BufferingServerTransport(actorContext, context);
    }

    protected TransportContext buildTransportContext() {
        ServerSocketBinding serverSocketBinding = new ServerSocketBinding(this.bindAddress);
        serverSocketBinding.doBind();
        TransportContext context = new TransportContext();
        context.setName(this.name);
        context.setServerOutput(this.output);
        context.setMessageMaxLength(this.messageMaxLength);
        context.setRemoteAddressList(this.remoteAddressList);
        context.setReceiveHandler(this.receiveHandler);
        context.setServerSocketBinding(serverSocketBinding);
        context.setChannelFactory(new DefaultChannelFactory());
        return context;
    }

    protected void buildActors(TransportContext context, ServerActorContext actorContext) {
        ServerConductor conductor = new ServerConductor(actorContext, context);
        Sender sender = actorContext.getSender();
        Receiver receiver = new Receiver(actorContext, context);
        this.scheduler.submitActor((Actor)conductor);
        this.scheduler.submitActor((Actor)sender);
        this.scheduler.submitActor((Actor)receiver);
    }

    protected void validate() {
        Objects.requireNonNull(this.scheduler, "Scheduler must be provided");
        Objects.requireNonNull(this.bindAddress, "Bind Address must be provided");
        Objects.requireNonNull(this.receiveHandler, "Receive Handler must be defined");
    }
}

