/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport;

import io.zeebe.dispatcher.ClaimedFragment;
import io.zeebe.dispatcher.Dispatcher;
import io.zeebe.transport.RemoteAddress;
import io.zeebe.transport.impl.RequestResponseHeaderDescriptor;
import io.zeebe.transport.impl.TransportHeaderDescriptor;
import io.zeebe.util.buffer.BufferWriter;
import io.zeebe.util.buffer.DirectBufferWriter;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public class ServerResponse
implements BufferWriter {
    protected final TransportHeaderDescriptor transportHeaderDescriptor = new TransportHeaderDescriptor();
    protected final ClaimedFragment claimedFragment = new ClaimedFragment();
    protected final DirectBufferWriter writerAdapter = new DirectBufferWriter();
    private final RequestResponseHeaderDescriptor requestResponseHeaderDescriptor = new RequestResponseHeaderDescriptor();
    protected BufferWriter writer;
    protected int remoteStreamId;
    private long requestId;

    public ServerResponse writer(BufferWriter writer) {
        this.writer = writer;
        return this;
    }

    public ServerResponse buffer(DirectBuffer buffer) {
        return this.buffer(buffer, 0, buffer.capacity());
    }

    public ServerResponse buffer(DirectBuffer buffer, int offset, int length) {
        return this.writer((BufferWriter)this.writerAdapter.wrap(buffer, offset, length));
    }

    public ServerResponse remoteAddress(RemoteAddress remoteAddress) {
        this.remoteStreamId = remoteAddress.getStreamId();
        return this;
    }

    public ServerResponse remoteStreamId(int remoteStreamId) {
        this.remoteStreamId = remoteStreamId;
        return this;
    }

    public ServerResponse reset() {
        this.remoteStreamId = -1;
        this.writer = null;
        this.requestId = -1L;
        return this;
    }

    public ServerResponse requestId(long requestId) {
        this.requestId = requestId;
        return this;
    }

    public boolean trySend(Dispatcher sendBuffer) {
        long claimedOffset;
        int requiredLength = this.getLength();
        while ((claimedOffset = sendBuffer.claim(this.claimedFragment, requiredLength, this.remoteStreamId)) == -2L) {
        }
        if (claimedOffset >= 0L) {
            try {
                MutableDirectBuffer buffer = this.claimedFragment.getBuffer();
                int writeOffset = this.claimedFragment.getOffset();
                this.write(buffer, writeOffset);
                this.claimedFragment.commit();
                return true;
            }
            catch (Throwable e) {
                this.claimedFragment.abort();
            }
        }
        return false;
    }

    public int getLength() {
        return RequestResponseHeaderDescriptor.framedLength(TransportHeaderDescriptor.framedLength(this.writer.getLength()));
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        this.transportHeaderDescriptor.wrap((DirectBuffer)buffer, offset).putProtocolRequestReponse();
        this.requestResponseHeaderDescriptor.wrap((DirectBuffer)buffer, offset += TransportHeaderDescriptor.headerLength()).requestId(this.requestId);
        this.writer.write(buffer, offset += RequestResponseHeaderDescriptor.headerLength());
    }

    public BufferWriter getWriter() {
        return this.writer;
    }

    public long getRequestId() {
        return this.requestId;
    }

    public int getRemoteStreamId() {
        return this.remoteStreamId;
    }
}

