/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport;

import io.zeebe.dispatcher.Dispatcher;
import io.zeebe.dispatcher.FragmentHandler;
import io.zeebe.transport.ClientInputListener;
import io.zeebe.transport.ClientTransport;
import io.zeebe.transport.EndpointRegistry;
import io.zeebe.transport.impl.ClientOutputImpl;
import io.zeebe.transport.impl.ClientReceiveHandler;
import io.zeebe.transport.impl.DefaultChannelFactory;
import io.zeebe.transport.impl.EndpointRegistryImpl;
import io.zeebe.transport.impl.RemoteAddressListImpl;
import io.zeebe.transport.impl.TransportChannelFactory;
import io.zeebe.transport.impl.TransportContext;
import io.zeebe.transport.impl.actor.ClientActorContext;
import io.zeebe.transport.impl.actor.ClientConductor;
import io.zeebe.transport.impl.actor.Receiver;
import io.zeebe.transport.impl.memory.NonBlockingMemoryPool;
import io.zeebe.transport.impl.memory.TransportMemoryPool;
import io.zeebe.transport.impl.sender.Sender;
import io.zeebe.util.ByteValue;
import io.zeebe.util.sched.Actor;
import io.zeebe.util.sched.ActorScheduler;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ClientTransportBuilder {
    protected static final Duration DEFAULT_CHANNEL_KEEP_ALIVE_PERIOD = Duration.ofSeconds(5L);
    protected static final long DEFAULT_CHANNEL_CONNECT_TIMEOUT = 500L;
    private final String name;
    protected Duration keepAlivePeriod = DEFAULT_CHANNEL_KEEP_ALIVE_PERIOD;
    protected Dispatcher receiveBuffer;
    protected List<ClientInputListener> listeners;
    protected TransportChannelFactory channelFactory;
    protected Duration defaultRequestRetryTimeout = Duration.ofSeconds(15L);
    protected Duration defaultMessageRetryTimeout = Duration.ofSeconds(1L);
    private int messageMaxLength = 524288;
    private ActorScheduler scheduler;
    private TransportMemoryPool requestMemoryPool = new NonBlockingMemoryPool(ByteValue.ofMegabytes((long)4L));
    private TransportMemoryPool messageMemoryPool = new NonBlockingMemoryPool(ByteValue.ofMegabytes((long)4L));

    public ClientTransportBuilder(String name) {
        this.name = name;
    }

    public ClientTransportBuilder scheduler(ActorScheduler scheduler) {
        this.scheduler = scheduler;
        return this;
    }

    public ClientTransportBuilder messageReceiveBuffer(Dispatcher receiveBuffer) {
        this.receiveBuffer = receiveBuffer;
        return this;
    }

    public ClientTransportBuilder requestMemoryPool(TransportMemoryPool requestMemoryPool) {
        this.requestMemoryPool = requestMemoryPool;
        return this;
    }

    public ClientTransportBuilder messageMemoryPool(TransportMemoryPool messageMemoryPool) {
        this.messageMemoryPool = messageMemoryPool;
        return this;
    }

    public ClientTransportBuilder inputListener(ClientInputListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ClientInputListener>();
        }
        this.listeners.add(listener);
        return this;
    }

    public ClientTransportBuilder messageMaxLength(int messageMaxLength) {
        this.messageMaxLength = messageMaxLength;
        return this;
    }

    public ClientTransportBuilder keepAlivePeriod(Duration keepAlivePeriod) {
        if (keepAlivePeriod.getSeconds() < 1L) {
            throw new RuntimeException("Min value for keepalive period is 1s.");
        }
        this.keepAlivePeriod = keepAlivePeriod;
        return this;
    }

    public ClientTransportBuilder channelFactory(TransportChannelFactory channelFactory) {
        this.channelFactory = channelFactory;
        return this;
    }

    public ClientTransportBuilder defaultRequestRetryTimeout(Duration duration) {
        this.defaultRequestRetryTimeout = duration;
        return this;
    }

    public ClientTransportBuilder defaultMessageRetryTimeout(Duration duration) {
        this.defaultMessageRetryTimeout = duration;
        return this;
    }

    public ClientTransport build() {
        this.validate();
        ClientActorContext actorContext = new ClientActorContext();
        Sender sender = new Sender(actorContext, this.messageMemoryPool, this.requestMemoryPool, this.keepAlivePeriod);
        RemoteAddressListImpl remoteAddressList = new RemoteAddressListImpl();
        EndpointRegistryImpl endpointRegistry = new EndpointRegistryImpl(this.name, remoteAddressList);
        TransportContext transportContext = this.buildTransportContext(remoteAddressList, endpointRegistry, new ClientReceiveHandler(sender, this.receiveBuffer, this.listeners), this.receiveBuffer);
        return this.build(actorContext, transportContext);
    }

    protected TransportContext buildTransportContext(RemoteAddressListImpl addressList, EndpointRegistry endpointRegistry, FragmentHandler receiveHandler, Dispatcher receiveBuffer) {
        TransportContext context = new TransportContext();
        context.setName("client");
        context.setReceiveBuffer(receiveBuffer);
        context.setMessageMaxLength(this.messageMaxLength);
        context.setRemoteAddressList(addressList);
        context.setEndpointRegistry(endpointRegistry);
        context.setReceiveHandler(receiveHandler);
        context.setChannelKeepAlivePeriod(this.keepAlivePeriod);
        if (this.channelFactory != null) {
            context.setChannelFactory(this.channelFactory);
        } else {
            context.setChannelFactory(new DefaultChannelFactory());
        }
        return context;
    }

    protected ClientTransport build(ClientActorContext actorContext, TransportContext context) {
        ClientConductor conductor = new ClientConductor(actorContext, context);
        Receiver receiver = new Receiver(actorContext, context);
        Sender sender = actorContext.getSender();
        ClientOutputImpl output = new ClientOutputImpl(context.getEndpointRegistry(), sender, this.defaultRequestRetryTimeout, this.defaultMessageRetryTimeout);
        context.setClientOutput(output);
        this.scheduler.submitActor((Actor)conductor);
        this.scheduler.submitActor((Actor)receiver);
        this.scheduler.submitActor((Actor)sender);
        return new ClientTransport(actorContext, context);
    }

    private void validate() {
        Objects.requireNonNull(this.scheduler, "Scheduler must be provided");
    }
}

