/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport.impl.memory;

import io.zeebe.transport.Loggers;
import io.zeebe.transport.impl.memory.TransportMemoryPool;
import io.zeebe.util.ByteValue;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;

public class NonBlockingMemoryPool
implements TransportMemoryPool {
    private static final Logger LOG = Loggers.TRANSPORT_MEMORY_LOGGER;
    private final AtomicInteger remaining;

    public NonBlockingMemoryPool(int capacity) {
        this.remaining = new AtomicInteger(capacity);
    }

    public NonBlockingMemoryPool(ByteValue byteValue) {
        this((int)byteValue.toBytes());
    }

    @Override
    public ByteBuffer allocate(int requestedCapacity) {
        int newRemaining;
        int current;
        LOG.trace("Attempting to allocate {} bytes", (Object)requestedCapacity);
        boolean canAllocate = true;
        do {
            boolean bl = canAllocate = (newRemaining = (current = this.remaining.get()) - requestedCapacity) > 0;
        } while (canAllocate && !this.remaining.compareAndSet(current, newRemaining));
        if (canAllocate) {
            LOG.trace("Attocated {} bytes", (Object)requestedCapacity);
            return ByteBuffer.allocate(requestedCapacity);
        }
        LOG.trace("Failed to allocate {} bytes", (Object)requestedCapacity);
        return null;
    }

    @Override
    public void reclaim(ByteBuffer buffer) {
        int bytesReclaimed = buffer.capacity();
        LOG.trace("Reclaiming {} bytes", (Object)bytesReclaimed);
        this.remaining.addAndGet(bytesReclaimed);
    }
}

