/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport.impl.actor;

import io.zeebe.dispatcher.Subscription;
import io.zeebe.transport.ServerInputSubscription;
import io.zeebe.transport.ServerMessageHandler;
import io.zeebe.transport.ServerOutput;
import io.zeebe.transport.ServerRequestHandler;
import io.zeebe.transport.SocketAddress;
import io.zeebe.transport.impl.RemoteAddressImpl;
import io.zeebe.transport.impl.RemoteAddressListImpl;
import io.zeebe.transport.impl.ServerInputSubscriptionImpl;
import io.zeebe.transport.impl.ServerSocketBinding;
import io.zeebe.transport.impl.TransportChannel;
import io.zeebe.transport.impl.TransportContext;
import io.zeebe.transport.impl.actor.Conductor;
import io.zeebe.transport.impl.actor.ServerActorContext;
import io.zeebe.transport.impl.selector.AcceptTransportPoller;
import io.zeebe.util.sched.future.ActorFuture;
import io.zeebe.util.sched.future.CompletableActorFuture;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;

public class ServerConductor
extends Conductor {
    private final AcceptTransportPoller acceptTransportPoller;
    private ServerSocketBinding serverSocketBinding;

    public ServerConductor(ServerActorContext actorContext, TransportContext context) {
        super(actorContext, context);
        this.serverSocketBinding = context.getServerSocketBinding();
        this.acceptTransportPoller = new AcceptTransportPoller(this);
        this.acceptTransportPoller.addServerSocketBinding(this.serverSocketBinding);
    }

    protected void onActorStarted() {
        super.onActorStarted();
        this.actor.pollBlocking(this.acceptTransportPoller::pollBlocking, this.acceptTransportPoller::processKeys);
    }

    @Override
    protected void onActorClosing() {
        this.acceptTransportPoller.close();
        super.onActorClosing();
    }

    @Override
    protected void onSenderAndReceiverClosed() {
        this.serverSocketBinding.close();
    }

    public void onServerChannelOpened(SocketChannel serverChannel) {
        SocketAddress socketAddress = null;
        try {
            socketAddress = new SocketAddress((InetSocketAddress)serverChannel.getRemoteAddress());
        }
        catch (IOException e) {
            try {
                serverChannel.close();
            }
            catch (IOException e1) {
                return;
            }
        }
        RemoteAddressImpl remoteAddress = this.remoteAddressList.getByAddress(socketAddress);
        if (remoteAddress != null) {
            this.remoteAddressList.retire(remoteAddress);
        }
        remoteAddress = this.remoteAddressList.register(socketAddress);
        TransportChannel ch = this.channelFactory.buildServerChannel(this, remoteAddress, this.transportContext.getMessageMaxLength(), this.transportContext.getReceiveHandler(), serverChannel);
        this.onChannelConnected(ch);
    }

    public ActorFuture<ServerInputSubscription> openInputSubscription(String subscriptionName, ServerOutput output, RemoteAddressListImpl remoteAddressList, ServerMessageHandler messageHandler, ServerRequestHandler requestHandler) {
        CompletableActorFuture future = new CompletableActorFuture();
        this.actor.call(() -> this.actor.runOnCompletion(this.transportContext.getReceiveBuffer().openSubscriptionAsync(subscriptionName), (s, t) -> {
            if (t == null) {
                future.complete((Object)new ServerInputSubscriptionImpl(output, (Subscription)s, remoteAddressList, messageHandler, requestHandler));
            } else {
                future.completeExceptionally(t);
            }
        }));
        return future;
    }
}

