/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.test.exporter;

import io.zeebe.exporter.api.context.Controller;
import io.zeebe.test.exporter.MockScheduledTask;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class MockController
implements Controller {
    public static final long UNKNOWN_POSITION = -1L;
    private final List<MockScheduledTask> scheduledTasks = new ArrayList<MockScheduledTask>();
    private long lastRanAtMs = 0L;
    private long position = -1L;

    public void updateLastExportedRecordPosition(long position) {
        this.position = position;
    }

    public void scheduleTask(Duration delay, Runnable task) {
        MockScheduledTask scheduledTask = new MockScheduledTask(delay, task);
        this.scheduledTasks.add(scheduledTask);
    }

    public void resetScheduler() {
        this.lastRanAtMs = 0L;
        this.scheduledTasks.clear();
    }

    public List<MockScheduledTask> getScheduledTasks() {
        return this.scheduledTasks;
    }

    public long getPosition() {
        return this.position;
    }

    public void runScheduledTasks(Duration elapsed) {
        Duration upperBound = elapsed.plusMillis(this.lastRanAtMs);
        this.scheduledTasks.stream().filter(t -> t.getDelay().compareTo(upperBound) <= 0).sorted(Comparator.comparing(MockScheduledTask::getDelay)).forEach(MockScheduledTask::run);
        this.lastRanAtMs = upperBound.toMillis();
    }
}

