/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.test;

import io.zeebe.client.api.response.WorkflowInstanceEvent;
import io.zeebe.client.impl.ZeebeObjectMapper;
import io.zeebe.protocol.record.Record;
import io.zeebe.protocol.record.intent.WorkflowInstanceIntent;
import io.zeebe.protocol.record.value.WorkflowInstanceRecordValue;
import io.zeebe.test.util.record.RecordingExporter;
import io.zeebe.test.util.record.WorkflowInstanceRecordStream;
import io.zeebe.test.util.record.WorkflowInstances;
import io.zeebe.test.util.stream.StreamWrapperException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractAssert;

public class WorkflowInstanceAssert
extends AbstractAssert<WorkflowInstanceAssert, WorkflowInstanceEvent> {
    private static final ZeebeObjectMapper OBJECT_MAPPER = new ZeebeObjectMapper();
    private static final List<WorkflowInstanceIntent> ELEMENT_PASSED_INTENTS = Arrays.asList(WorkflowInstanceIntent.ELEMENT_COMPLETED, WorkflowInstanceIntent.SEQUENCE_FLOW_TAKEN);
    private static final List<WorkflowInstanceIntent> INSTANCE_ENDED_INTENTS = Arrays.asList(WorkflowInstanceIntent.ELEMENT_COMPLETED, WorkflowInstanceIntent.ELEMENT_TERMINATED);
    private final long workflowInstanceKey;

    public WorkflowInstanceAssert(WorkflowInstanceEvent actual) {
        super((Object)actual, WorkflowInstanceAssert.class);
        this.workflowInstanceKey = actual.getWorkflowInstanceKey();
    }

    public static WorkflowInstanceAssert assertThat(WorkflowInstanceEvent actual) {
        return new WorkflowInstanceAssert(actual);
    }

    public WorkflowInstanceAssert isEnded() {
        boolean isEnded = this.exists((WorkflowInstanceRecordStream)((WorkflowInstanceRecordStream)RecordingExporter.workflowInstanceRecords().withWorkflowInstanceKey(this.workflowInstanceKey).withRecordKey(this.workflowInstanceKey)).filter(WorkflowInstanceAssert.intent(INSTANCE_ENDED_INTENTS)));
        if (!isEnded) {
            this.failWithMessage("Expected workflow instance to be <ended> but was <active>", new Object[0]);
        }
        return this;
    }

    public WorkflowInstanceAssert hasPassed(String ... elementIds) {
        List<String> ids = Arrays.asList(elementIds);
        List passedElements = ((WorkflowInstanceRecordStream)((WorkflowInstanceRecordStream)RecordingExporter.workflowInstanceRecords().withWorkflowInstanceKey(this.workflowInstanceKey).filter(WorkflowInstanceAssert.intent(ELEMENT_PASSED_INTENTS))).filter(WorkflowInstanceAssert.elementId(ids))).map(r -> ((WorkflowInstanceRecordValue)r.getValue()).getElementId()).limit(ids.size()).collect(Collectors.toList());
        if (passedElements.size() < ids.size()) {
            ArrayList<String> notPassed = new ArrayList<String>(ids);
            notPassed.removeAll(passedElements);
            this.failWithMessage("Expected <%s> to be passed but could not find <%s>", new Object[]{ids, notPassed});
        }
        return this;
    }

    public WorkflowInstanceAssert hasEntered(String ... elementIds) {
        List<String> ids = Arrays.asList(elementIds);
        List enteredElements = ((WorkflowInstanceRecordStream)RecordingExporter.workflowInstanceRecords((WorkflowInstanceIntent)WorkflowInstanceIntent.ELEMENT_ACTIVATED).withWorkflowInstanceKey(this.workflowInstanceKey).filter(WorkflowInstanceAssert.elementId(ids))).map(r -> ((WorkflowInstanceRecordValue)r.getValue()).getElementId()).limit(ids.size()).collect(Collectors.toList());
        if (enteredElements.size() < ids.size()) {
            ArrayList<String> notEntered = new ArrayList<String>(ids);
            notEntered.removeAll(enteredElements);
            this.failWithMessage("Expected <%s> to be entered but could not find <%s>", new Object[]{ids, notEntered});
        }
        return this;
    }

    public WorkflowInstanceAssert hasCompleted(String ... elementIds) {
        List<String> ids = Arrays.asList(elementIds);
        List completedElements = ((WorkflowInstanceRecordStream)RecordingExporter.workflowInstanceRecords((WorkflowInstanceIntent)WorkflowInstanceIntent.ELEMENT_COMPLETED).withWorkflowInstanceKey(this.workflowInstanceKey).filter(WorkflowInstanceAssert.elementId(ids))).map(r -> ((WorkflowInstanceRecordValue)r.getValue()).getElementId()).limit(ids.size()).collect(Collectors.toList());
        if (completedElements.size() < ids.size()) {
            ArrayList<String> notCompleted = new ArrayList<String>(ids);
            notCompleted.removeAll(completedElements);
            this.failWithMessage("Expected <%s> to be completed but could not find <%s>", new Object[]{ids, notCompleted});
        }
        return this;
    }

    public WorkflowInstanceAssert hasVariable(String key, Object expectedValue) {
        Optional record = ((WorkflowInstanceRecordStream)((WorkflowInstanceRecordStream)RecordingExporter.workflowInstanceRecords().withWorkflowInstanceKey(this.workflowInstanceKey).withRecordKey(this.workflowInstanceKey)).filter(WorkflowInstanceAssert.intent(INSTANCE_ENDED_INTENTS))).findFirst();
        if (record.isPresent()) {
            this.hasVariable((Record<WorkflowInstanceRecordValue>)((Record)record.get()), key, expectedValue);
        } else {
            this.failWithMessage("Expected workflow instance to contain variables but instance is not ended", new Object[0]);
        }
        return this;
    }

    private WorkflowInstanceAssert hasVariable(Record<WorkflowInstanceRecordValue> record, String key, Object expectedValue) {
        Object value;
        Map variables = WorkflowInstances.getCurrentVariables((long)this.workflowInstanceKey, (long)record.getPosition());
        if (!variables.containsKey(key)) {
            this.failWithMessage("Expected variables <%s> to contain <%s> but could not find entry", new Object[]{variables, key});
            return this;
        }
        try {
            value = OBJECT_MAPPER.readValue((String)variables.get(key), Object.class);
        }
        catch (IOException e) {
            this.failWithMessage("Expected variable values to be JSON, but got <%s>", new Object[]{e.getMessage()});
            return this;
        }
        if (expectedValue == null && value != null || expectedValue != null && !expectedValue.equals(value)) {
            this.failWithMessage("Expected variables value of <%s> to be <%s> but was <%s>", new Object[]{key, expectedValue, value});
        }
        return this;
    }

    private boolean exists(WorkflowInstanceRecordStream stream) {
        try {
            return stream.exists();
        }
        catch (StreamWrapperException e) {
            return false;
        }
    }

    private static Predicate<Record<WorkflowInstanceRecordValue>> intent(List<WorkflowInstanceIntent> intents) {
        return record -> intents.contains(record.getIntent());
    }

    private static Predicate<Record<WorkflowInstanceRecordValue>> elementId(List<String> elementIds) {
        return record -> {
            String elementId = ((WorkflowInstanceRecordValue)record.getValue()).getElementId();
            return elementIds.contains(elementId);
        };
    }
}

