/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.test;

import io.zeebe.broker.Broker;
import io.zeebe.broker.clustering.base.partitions.Partition;
import io.zeebe.broker.clustering.base.partitions.PartitionServiceNames;
import io.zeebe.broker.system.configuration.BrokerCfg;
import io.zeebe.broker.system.configuration.ExporterCfg;
import io.zeebe.broker.system.configuration.NetworkCfg;
import io.zeebe.broker.transport.TransportServiceNames;
import io.zeebe.servicecontainer.Injector;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceContainer;
import io.zeebe.servicecontainer.ServiceName;
import io.zeebe.servicecontainer.ServiceStartContext;
import io.zeebe.servicecontainer.ServiceStopContext;
import io.zeebe.test.util.record.RecordingExporter;
import io.zeebe.test.util.record.RecordingExporterTestWatcher;
import io.zeebe.transport.SocketAddress;
import io.zeebe.transport.impl.util.SocketUtil;
import io.zeebe.util.FileUtil;
import io.zeebe.util.TomlConfigurationReader;
import io.zeebe.util.ZbLogger;
import io.zeebe.util.allocation.DirectBufferAllocator;
import io.zeebe.util.sched.clock.ActorClock;
import io.zeebe.util.sched.clock.ControlledActorClock;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.assertj.core.util.Files;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;

public class EmbeddedBrokerRule
extends ExternalResource {
    public static final String DEFAULT_CONFIG_FILE = "zeebe.test.cfg.toml";
    public static final int DEFAULT_TIMEOUT = 25;
    public static final String TEST_RECORD_EXPORTER_ID = "test-recorder";
    protected static final Logger LOG = new ZbLogger("io.zeebe.test");
    private static final String SNAPSHOTS_DIRECTORY = "snapshots";
    private static final String STATE_DIRECTORY = "state";
    protected final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();
    protected final BrokerCfg brokerCfg;
    protected final ControlledActorClock controlledActorClock = new ControlledActorClock();
    protected final Supplier<InputStream> configSupplier;
    protected final Consumer<BrokerCfg>[] configurators;
    private final int timeout;
    private final File newTemporaryFolder;
    protected Broker broker;
    protected long startTime;
    private List<String> dataDirectories;

    @SafeVarargs
    public EmbeddedBrokerRule(Consumer<BrokerCfg> ... configurators) {
        this(DEFAULT_CONFIG_FILE, configurators);
    }

    @SafeVarargs
    public EmbeddedBrokerRule(String configFileClasspathLocation, Consumer<BrokerCfg> ... configurators) {
        this(() -> EmbeddedBrokerRule.class.getClassLoader().getResourceAsStream(configFileClasspathLocation), 25, configurators);
    }

    @SafeVarargs
    public EmbeddedBrokerRule(Supplier<InputStream> configSupplier, int timeout, Consumer<BrokerCfg> ... configurators) {
        this.configSupplier = configSupplier;
        this.configurators = configurators;
        this.timeout = timeout;
        this.newTemporaryFolder = Files.newTemporaryFolder();
        try (InputStream configStream = configSupplier.get();){
            this.brokerCfg = configStream == null ? new BrokerCfg() : (BrokerCfg)TomlConfigurationReader.read((InputStream)configStream, BrokerCfg.class);
            this.configureBroker(this.brokerCfg);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to open configuration", e);
        }
    }

    private static void deleteSnapshots(File parentDir) {
        File snapshotDirectory = new File(parentDir, SNAPSHOTS_DIRECTORY);
        if (snapshotDirectory.exists()) {
            try {
                FileUtil.deleteFolder((String)snapshotDirectory.getAbsolutePath());
            }
            catch (IOException e) {
                throw new RuntimeException("Could not delete snapshot directory " + snapshotDirectory.getAbsolutePath(), e);
            }
        }
    }

    public static void assignSocketAddresses(BrokerCfg brokerCfg) {
        NetworkCfg network = brokerCfg.getNetwork();
        brokerCfg.getGateway().getNetwork().setPort(SocketUtil.getNextAddress().port());
        network.getCommandApi().setPort(SocketUtil.getNextAddress().port());
        network.getInternalApi().setPort(SocketUtil.getNextAddress().port());
        network.getMonitoringApi().setPort(SocketUtil.getNextAddress().port());
    }

    public Statement apply(Statement base, Description description) {
        Statement statement = this.recordingExporterTestWatcher.apply(base, description);
        return super.apply(statement, description);
    }

    protected void before() {
        this.startTime = System.currentTimeMillis();
        this.startBroker();
        LOG.info("\n====\nBroker startup time: {}\n====\n", (Object)(System.currentTimeMillis() - this.startTime));
        this.startTime = System.currentTimeMillis();
    }

    protected void after() {
        try {
            LOG.info("Test execution time: " + (System.currentTimeMillis() - this.startTime));
            this.startTime = System.currentTimeMillis();
            this.stopBroker();
            LOG.info("Broker closing time: " + (System.currentTimeMillis() - this.startTime));
            long allocatedMemoryInKb = DirectBufferAllocator.getAllocatedMemoryInKb();
            if (allocatedMemoryInKb > 0L) {
                LOG.warn("There are still allocated direct buffers of a total size of {}kB.", (Object)allocatedMemoryInKb);
            }
        }
        finally {
            try {
                FileUtil.deleteFolder((String)this.newTemporaryFolder.getAbsolutePath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public BrokerCfg getBrokerCfg() {
        return this.brokerCfg;
    }

    public SocketAddress getGatewayAddress() {
        return this.brokerCfg.getGateway().getNetwork().toSocketAddress();
    }

    public Broker getBroker() {
        return this.broker;
    }

    public ControlledActorClock getClock() {
        return this.controlledActorClock;
    }

    public void restartBroker() {
        this.stopBroker();
        this.startBroker();
    }

    public void stopBroker() {
        if (this.broker != null) {
            this.broker.close();
            this.broker = null;
            System.gc();
        }
    }

    public void startBroker() {
        this.startTime = System.currentTimeMillis();
        this.broker = new Broker(this.brokerCfg, this.newTemporaryFolder.getAbsolutePath(), (ActorClock)this.controlledActorClock);
        ServiceContainer serviceContainer = this.broker.getBrokerContext().getServiceContainer();
        try {
            String partitionName = Partition.getPartitionName((int)1);
            serviceContainer.createService(TestService.NAME, (Service)new TestService()).dependency(PartitionServiceNames.leaderPartitionServiceName((String)partitionName)).dependency(TransportServiceNames.serverTransport((String)"commandApi.server")).install().get((long)this.timeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            this.stopBroker();
            throw new RuntimeException(String.format("System partition not installed into the container withing %d seconds.", this.timeout), e);
        }
        this.dataDirectories = this.broker.getBrokerContext().getBrokerConfiguration().getData().getDirectories();
    }

    public void configureBroker(BrokerCfg brokerCfg) {
        ExporterCfg exporterCfg = new ExporterCfg();
        exporterCfg.setId(TEST_RECORD_EXPORTER_ID);
        exporterCfg.setClassName(RecordingExporter.class.getName());
        brokerCfg.getExporters().add(exporterCfg);
        for (Consumer<BrokerCfg> configurator : this.configurators) {
            configurator.accept(brokerCfg);
        }
        EmbeddedBrokerRule.assignSocketAddresses(brokerCfg);
    }

    public void purgeSnapshots() {
        for (String dataDirectoryName : this.dataDirectories) {
            File[] partitionDirectories;
            File dataDirectory = new File(dataDirectoryName);
            for (File partitionDirectory : partitionDirectories = dataDirectory.listFiles((d, f) -> new File(d, f).isDirectory())) {
                File stateDirectory = new File(partitionDirectory, STATE_DIRECTORY);
                if (!stateDirectory.exists()) continue;
                EmbeddedBrokerRule.deleteSnapshots(stateDirectory);
            }
        }
    }

    public <S> S getService(ServiceName<S> serviceName) {
        ServiceContainer serviceContainer = this.broker.getBrokerContext().getServiceContainer();
        Injector injector = new Injector();
        ServiceName accessorServiceName = ServiceName.newServiceName((String)("serviceAccess" + serviceName.getName()), TestService.class);
        try {
            serviceContainer.createService(accessorServiceName, (Service)new TestService()).dependency(serviceName, injector).install().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        serviceContainer.removeService(accessorServiceName);
        return (S)injector.getValue();
    }

    public <T> void removeService(ServiceName<T> name) {
        try {
            this.broker.getBrokerContext().getServiceContainer().removeService(name).get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new RuntimeException("Could not remove service " + name.getName() + " in 10 seconds.");
        }
    }

    static class TestService
    implements Service<TestService> {
        static final ServiceName<TestService> NAME = ServiceName.newServiceName((String)"testService", TestService.class);

        TestService() {
        }

        public void start(ServiceStartContext startContext) {
        }

        public void stop(ServiceStopContext stopContext) {
        }

        public TestService get() {
            return this;
        }
    }
}

