/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.test;

import io.zeebe.client.ZeebeClient;
import java.util.Properties;
import java.util.function.Supplier;
import org.junit.rules.ExternalResource;

public class ClientRule
extends ExternalResource {
    protected final Supplier<Properties> properties;
    protected ZeebeClient client;

    public ClientRule() {
        this(Properties::new);
    }

    public ClientRule(Supplier<Properties> propertiesProvider) {
        this.properties = propertiesProvider;
    }

    public ZeebeClient getClient() {
        return this.client;
    }

    protected void before() {
        this.createClient();
    }

    protected void after() {
        this.destroyClient();
    }

    public void createClient() {
        this.client = ZeebeClient.newClientBuilder().withProperties(this.properties.get()).build();
    }

    public void destroyClient() {
        this.client.close();
        this.client = null;
    }
}

