/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.test.exporter.record;

import io.zeebe.protocol.record.RecordType;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.ValueType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.WorkflowInstanceCreationIntent;
import io.zeebe.test.exporter.record.ExporterMappedObject;
import java.util.Objects;

public class MockRecordMetadata
extends ExporterMappedObject
implements Cloneable {
    private Intent intent = WorkflowInstanceCreationIntent.CREATE;
    private int partitionId = 0;
    private RecordType recordType = RecordType.COMMAND;
    private RejectionType rejectionType = RejectionType.NULL_VAL;
    private String rejectionReason = "";
    private ValueType valueType = ValueType.WORKFLOW_INSTANCE_CREATION;

    public MockRecordMetadata() {
    }

    public MockRecordMetadata(Intent intent, int partitionId, RecordType recordType, RejectionType rejectionType, String rejectionReason, ValueType valueType) {
        this.intent = intent;
        this.partitionId = partitionId;
        this.recordType = recordType;
        this.rejectionType = rejectionType;
        this.rejectionReason = rejectionReason;
        this.valueType = valueType;
    }

    public Intent getIntent() {
        return this.intent;
    }

    public MockRecordMetadata setIntent(Intent intent) {
        this.intent = intent;
        return this;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public MockRecordMetadata setPartitionId(int partitionId) {
        this.partitionId = partitionId;
        return this;
    }

    public RecordType getRecordType() {
        return this.recordType;
    }

    public MockRecordMetadata setRecordType(RecordType recordType) {
        this.recordType = recordType;
        return this;
    }

    public RejectionType getRejectionType() {
        return this.rejectionType;
    }

    public MockRecordMetadata setRejectionType(RejectionType rejectionType) {
        this.rejectionType = rejectionType;
        return this;
    }

    public String getRejectionReason() {
        return this.rejectionReason;
    }

    public MockRecordMetadata setRejectionReason(String rejectionReason) {
        this.rejectionReason = rejectionReason;
        return this;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public MockRecordMetadata setValueType(ValueType valueType) {
        this.valueType = valueType;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MockRecordMetadata)) {
            return false;
        }
        MockRecordMetadata metadata = (MockRecordMetadata)o;
        return this.getPartitionId() == metadata.getPartitionId() && Objects.equals(this.getIntent(), metadata.getIntent()) && this.getRecordType() == metadata.getRecordType() && this.getRejectionType() == metadata.getRejectionType() && Objects.equals(this.getRejectionReason(), metadata.getRejectionReason()) && this.getValueType() == metadata.getValueType();
    }

    public int hashCode() {
        return Objects.hash(this.getIntent(), this.getPartitionId(), this.getRecordType(), this.getRejectionType(), this.getRejectionReason(), this.getValueType());
    }

    public String toString() {
        return "MockRecordMetadata{intent=" + this.intent + ", partitionId=" + this.partitionId + ", recordType=" + this.recordType + ", rejectionType=" + this.rejectionType + ", rejectionReason='" + this.rejectionReason + '\'' + ", valueType=" + this.valueType + '}';
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

