/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.test.exporter;

import com.moandjiezana.toml.Toml;
import io.zeebe.broker.system.configuration.BrokerCfg;
import io.zeebe.broker.system.configuration.ExporterCfg;
import io.zeebe.exporter.api.Exporter;
import io.zeebe.exporter.api.context.Context;
import io.zeebe.exporter.api.context.Controller;
import io.zeebe.protocol.record.Record;
import io.zeebe.test.exporter.MockConfiguration;
import io.zeebe.test.exporter.MockContext;
import io.zeebe.test.exporter.MockController;
import io.zeebe.test.exporter.record.MockRecord;
import io.zeebe.test.exporter.record.MockRecordMetadata;
import io.zeebe.test.exporter.record.MockRecordStream;
import io.zeebe.util.ZbLogger;
import java.io.File;
import java.io.InputStream;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class ExporterTestHarness {
    private final Logger logger = new ZbLogger("io.zeebe.broker.exporter");
    private final MockController controller = new MockController();
    private final Exporter exporter;
    private final int partitionId = 0;
    private MockContext context;
    private long position = 1L;

    public ExporterTestHarness(Exporter exporter) {
        this.exporter = exporter;
    }

    public void configure(String id) throws Exception {
        MockConfiguration configuration = new MockConfiguration();
        configuration.setId(id);
        this.exporter.configure((Context)this.newContext(configuration));
    }

    public void configure(String id, InputStream toml) throws Exception {
        BrokerCfg config = (BrokerCfg)new Toml().read(toml).to(BrokerCfg.class);
        this.configure(id, config);
    }

    public void configure(String id, File configFile) throws Exception {
        BrokerCfg config = (BrokerCfg)new Toml().read(configFile).to(BrokerCfg.class);
        this.configure(id, config);
    }

    public <T> void configure(String id, T config) throws Exception {
        MockConfiguration<T> configuration = new MockConfiguration<T>(config);
        configuration.setId(id);
        this.context = this.newContext(configuration);
        this.exporter.configure((Context)this.context);
    }

    public void open() {
        this.controller.resetScheduler();
        this.exporter.open((Controller)this.controller);
    }

    public void close() {
        this.exporter.close();
    }

    public MockRecord export() {
        MockRecord record = this.generateNextRecord();
        return this.export(record);
    }

    public MockRecord export(MockRecord record) {
        this.exporter.export((Record)record);
        this.position = record.getPosition();
        return record;
    }

    public MockRecord export(Consumer<MockRecord> configurator) {
        MockRecord record = this.generateNextRecord();
        if (configurator != null) {
            configurator.accept(record);
        }
        return this.export(record);
    }

    public Stream stream() {
        return new Stream((java.util.stream.Stream<MockRecord>)((Object)MockRecordStream.generate()));
    }

    public Stream stream(MockRecord seed) {
        return new Stream((java.util.stream.Stream<MockRecord>)((Object)MockRecordStream.generate(seed)));
    }

    public Stream stream(Consumer<MockRecord> configurator) {
        MockRecord seed = this.generateNextRecord();
        if (configurator != null) {
            configurator.accept(seed);
        }
        return this.stream(seed);
    }

    public void runScheduledTasks(Duration elapsed) {
        this.controller.runScheduledTasks(elapsed);
    }

    public MockController getController() {
        return this.controller;
    }

    public MockContext getContext() {
        return this.context;
    }

    public long getPosition() {
        return this.position;
    }

    public long getLastUpdatedPosition() {
        return this.controller.getPosition();
    }

    private void configure(String id, BrokerCfg brokerCfg) throws Exception {
        Optional<ExporterCfg> config = brokerCfg.getExporters().stream().filter(c -> c.getId().equals(id)).findFirst();
        if (!config.isPresent()) {
            throw new IllegalArgumentException(String.format("No exporter with ID %s found", id));
        }
        MockConfiguration configuration = new MockConfiguration();
        configuration.setId(id);
        configuration.setArguments(config.get().getArgs());
        this.context = this.newContext(configuration);
        this.exporter.configure((Context)this.context);
    }

    private <T> MockContext newContext(MockConfiguration<T> configuration) {
        return new MockContext(this.logger, configuration);
    }

    private MockRecord generateNextRecord() {
        return this.generateNextRecord(new MockRecord());
    }

    private MockRecord generateNextRecord(MockRecord seed) {
        return ((MockRecord)seed.clone()).setMetadata(new MockRecordMetadata().setPartitionId(0)).setTimestamp(System.currentTimeMillis()).setPosition(++this.position);
    }

    public class Stream
    extends MockRecordStream {
        public Stream(java.util.stream.Stream<MockRecord> wrappedStream) {
            super(wrappedStream);
        }

        public List<Record> export(int count) {
            return ((MockRecordStream)this.limit(count)).map(ExporterTestHarness.this::export).collect(Collectors.toList());
        }
    }
}

