/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.test.exporter;

import com.moandjiezana.toml.Toml;
import com.moandjiezana.toml.TomlWriter;
import io.zeebe.broker.system.configuration.BrokerCfg;
import io.zeebe.broker.system.configuration.ExporterCfg;
import io.zeebe.client.api.response.WorkflowInstanceEvent;
import io.zeebe.client.api.worker.JobHandler;
import io.zeebe.client.api.worker.JobWorker;
import io.zeebe.exporter.api.Exporter;
import io.zeebe.model.bpmn.Bpmn;
import io.zeebe.model.bpmn.BpmnModelInstance;
import io.zeebe.model.bpmn.builder.IntermediateCatchEventBuilder;
import io.zeebe.model.bpmn.builder.ServiceTaskBuilder;
import io.zeebe.protocol.record.Record;
import io.zeebe.protocol.record.intent.IncidentIntent;
import io.zeebe.protocol.record.intent.WorkflowInstanceIntent;
import io.zeebe.protocol.record.value.IncidentRecordValue;
import io.zeebe.test.ClientRule;
import io.zeebe.test.EmbeddedBrokerRule;
import io.zeebe.test.util.TestUtil;
import io.zeebe.test.util.record.RecordingExporter;
import io.zeebe.test.util.record.WorkflowInstanceRecordStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.junit.rules.ExternalResource;

public class ExporterIntegrationRule
extends ExternalResource {
    public static final BpmnModelInstance SAMPLE_WORKFLOW = Bpmn.createExecutableProcess((String)"testProcess").startEvent().intermediateCatchEvent("message", e -> {
        IntermediateCatchEventBuilder cfr_ignored_0 = (IntermediateCatchEventBuilder)e.message(m -> m.name("catch").zeebeCorrelationKey("orderId"));
    }).serviceTask("task", t -> {
        ServiceTaskBuilder cfr_ignored_0 = (ServiceTaskBuilder)((ServiceTaskBuilder)t.zeebeTaskType("work")).zeebeTaskHeader("foo", "bar");
    }).endEvent().done();
    private final EmbeddedBrokerRule brokerRule = new EmbeddedBrokerRule(new Consumer[0]);
    private ClientRule clientRule;

    protected void before() throws Throwable {
        super.before();
        if (!this.hasConfiguredExporters()) {
            this.start();
        }
    }

    protected void after() {
        super.after();
        this.stop();
    }

    public BrokerCfg getBrokerConfig() {
        return this.brokerRule.getBrokerCfg();
    }

    public List<ExporterCfg> getConfiguredExporters() {
        return this.getBrokerConfig().getExporters().stream().filter(cfg -> !cfg.getId().equals("test-recorder")).collect(Collectors.toList());
    }

    public boolean hasConfiguredExporters() {
        return this.getConfiguredExporters().isEmpty();
    }

    public <T> T getExporterConfiguration(String id, Class<T> configurationClass) {
        return (T)this.getConfiguredExporters().stream().filter(cfg -> cfg.getId().equals(id)).findFirst().map(cfg -> this.convertMapToConfig(cfg.getArgs(), configurationClass)).orElseThrow(() -> new IllegalArgumentException("No exporter with ID " + id + " configured"));
    }

    public ExporterIntegrationRule configure(InputStream toml) {
        BrokerCfg config = (BrokerCfg)new Toml().read(toml).to(BrokerCfg.class);
        return this.configure(config.getExporters());
    }

    public <T, E extends Exporter> ExporterIntegrationRule configure(String id, Class<E> exporterClass, T configuration) {
        Map<String, Object> arguments = this.convertConfigToMap(configuration);
        return this.configure(id, exporterClass, arguments);
    }

    public <E extends Exporter> ExporterIntegrationRule configure(String id, Class<E> exporterClass, Map<String, Object> arguments) {
        ExporterCfg config = new ExporterCfg();
        config.setId(id);
        config.setClassName(exporterClass.getCanonicalName());
        config.setArgs(arguments);
        return this.configure(Collections.singletonList(config));
    }

    public void start() {
        if (this.hasConfiguredExporters()) {
            throw new IllegalStateException("No exporter configured!");
        }
        this.brokerRule.startBroker();
        this.clientRule = new ClientRule(this::newClientProperties);
        this.clientRule.createClient();
    }

    public void stop() {
        this.brokerRule.stopBroker();
        if (this.clientRule != null) {
            this.clientRule.destroyClient();
        }
    }

    public void performSampleWorkload() {
        this.deployWorkflow(SAMPLE_WORKFLOW, "sample_workflow.bpmn");
        long workflowInstanceKey = this.createWorkflowInstance("testProcess", Collections.singletonMap("orderId", "foo-bar-123"));
        AtomicBoolean fail = new AtomicBoolean(true);
        JobWorker worker = this.createJobWorker("work", (client, job) -> {
            if (fail.getAndSet(false)) {
                client.newFailCommand(job.getKey()).retries(0).errorMessage("failed").send().join();
            } else {
                client.newCompleteCommand(job.getKey()).send().join();
            }
        });
        this.publishMessage("catch", "foo-bar-123");
        Record incident = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withWorkflowInstanceKey(workflowInstanceKey).withElementId("task").getFirst();
        this.clientRule.getClient().newUpdateRetriesCommand(((IncidentRecordValue)incident.getValue()).getJobKey()).retries(3).send().join();
        this.clientRule.getClient().newResolveIncidentCommand(incident.getKey()).send().join();
        this.awaitWorkflowCompletion(workflowInstanceKey);
        worker.close();
    }

    public void visitExportedRecords(Consumer<Record<?>> visitor) {
        RecordingExporter.getRecords().forEach(visitor);
    }

    public void deployWorkflow(BpmnModelInstance workflow, String filename) {
        this.clientRule.getClient().newDeployCommand().addWorkflowModel(workflow, filename).send().join();
    }

    public long createWorkflowInstance(String processId, Map<String, Object> variables) {
        return ((WorkflowInstanceEvent)this.clientRule.getClient().newCreateInstanceCommand().bpmnProcessId(processId).latestVersion().variables(variables).send().join()).getWorkflowInstanceKey();
    }

    public JobWorker createJobWorker(String type, JobHandler handler) {
        return this.clientRule.getClient().newWorker().jobType(type).handler(handler).open();
    }

    public void publishMessage(String messageName, String correlationKey) {
        this.clientRule.getClient().newPublishMessageCommand().messageName(messageName).correlationKey(correlationKey).send().join();
    }

    public void awaitWorkflowCompletion(long workflowInstanceKey) {
        TestUtil.waitUntil(() -> ((WorkflowInstanceRecordStream)RecordingExporter.workflowInstanceRecords((WorkflowInstanceIntent)WorkflowInstanceIntent.ELEMENT_COMPLETED).filter(r -> r.getKey() == workflowInstanceKey)).exists());
    }

    private Properties newClientProperties() {
        Properties properties = new Properties();
        properties.put("zeebe.client.broker.contactPoint", this.getBrokerConfig().getGateway().getNetwork().toSocketAddress().toString());
        return properties;
    }

    private ExporterIntegrationRule configure(List<ExporterCfg> exporters) {
        this.getBrokerConfig().getExporters().addAll(exporters);
        return this;
    }

    private <T> Map<String, Object> convertConfigToMap(T configuration) {
        return new Toml().read(new TomlWriter().write(configuration)).toMap();
    }

    private <T> T convertMapToConfig(Map<String, Object> map, Class<T> configClass) {
        return (T)new Toml().read(new TomlWriter().write(map)).to(configClass);
    }
}

