/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.test;

import io.zeebe.broker.system.configuration.BrokerCfg;
import io.zeebe.client.ZeebeClient;
import io.zeebe.client.api.response.WorkflowInstanceEvent;
import io.zeebe.test.ClientRule;
import io.zeebe.test.EmbeddedBrokerRule;
import io.zeebe.test.WorkflowInstanceAssert;
import io.zeebe.test.util.record.RecordingExporter;
import io.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class ZeebeTestRule
extends ExternalResource {
    private final EmbeddedBrokerRule brokerRule;
    private final ClientRule clientRule;
    protected final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    public ZeebeTestRule() {
        this("zeebe.test.cfg.toml", Properties::new);
    }

    public ZeebeTestRule(String configFileClasspathLocation, Supplier<Properties> propertiesProvider) {
        this.brokerRule = new EmbeddedBrokerRule(configFileClasspathLocation, new Consumer[0]);
        this.clientRule = new ClientRule(() -> {
            Properties properties = (Properties)propertiesProvider.get();
            properties.setProperty("zeebe.client.broker.contactPoint", this.brokerRule.getGatewayAddress().toString());
            return properties;
        });
    }

    public ZeebeClient getClient() {
        return this.clientRule.getClient();
    }

    public BrokerCfg getBrokerCfg() {
        return this.brokerRule.getBrokerCfg();
    }

    protected void before() {
        this.brokerRule.before();
        this.clientRule.before();
    }

    public Statement apply(Statement base, Description description) {
        Statement statement = this.recordingExporterTestWatcher.apply(base, description);
        return super.apply(statement, description);
    }

    protected void after() {
        this.clientRule.after();
        this.brokerRule.after();
    }

    public static WorkflowInstanceAssert assertThat(WorkflowInstanceEvent workflowInstance) {
        return WorkflowInstanceAssert.assertThat(workflowInstance);
    }

    public void printWorkflowInstanceEvents(long key) {
        RecordingExporter.workflowInstanceRecords().withWorkflowInstanceKey(key).forEach(event -> System.out.println("> " + event.toJson()));
    }
}

