/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.impl.record.value.workflowinstance;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.zeebe.msgpack.property.BaseProperty;
import io.zeebe.msgpack.property.DocumentProperty;
import io.zeebe.msgpack.property.IntegerProperty;
import io.zeebe.msgpack.property.LongProperty;
import io.zeebe.msgpack.property.StringProperty;
import io.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.zeebe.protocol.record.value.WorkflowInstanceCreationRecordValue;
import io.zeebe.util.buffer.BufferUtil;
import java.util.Map;
import org.agrona.DirectBuffer;

public class WorkflowInstanceCreationRecord
extends UnifiedRecordValue
implements WorkflowInstanceCreationRecordValue {
    private final StringProperty bpmnProcessIdProperty = new StringProperty("bpmnProcessId", "");
    private final LongProperty workflowKeyProperty = new LongProperty("workflowKey", -1L);
    private final IntegerProperty versionProperty = new IntegerProperty("version", -1);
    private final DocumentProperty variablesProperty = new DocumentProperty("variables");
    private final LongProperty workflowInstanceKeyProperty = new LongProperty("workflowInstanceKey", -1L);

    public WorkflowInstanceCreationRecord() {
        this.declareProperty((BaseProperty)this.bpmnProcessIdProperty).declareProperty((BaseProperty)this.workflowKeyProperty).declareProperty((BaseProperty)this.workflowInstanceKeyProperty).declareProperty((BaseProperty)this.versionProperty).declareProperty((BaseProperty)this.variablesProperty);
    }

    public String getBpmnProcessId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.bpmnProcessIdProperty.getValue());
    }

    public int getVersion() {
        return this.versionProperty.getValue();
    }

    public long getWorkflowKey() {
        return this.workflowKeyProperty.getValue();
    }

    public long getWorkflowInstanceKey() {
        return this.workflowInstanceKeyProperty.getValue();
    }

    public Map<String, Object> getVariables() {
        return MsgPackConverter.convertToMap(this.variablesProperty.getValue());
    }

    @JsonIgnore
    public DirectBuffer getBpmnProcessIdBuffer() {
        return this.bpmnProcessIdProperty.getValue();
    }

    @JsonIgnore
    public DirectBuffer getVariablesBuffer() {
        return this.variablesProperty.getValue();
    }

    public WorkflowInstanceCreationRecord setBpmnProcessId(String bpmnProcessId) {
        this.bpmnProcessIdProperty.setValue(bpmnProcessId);
        return this;
    }

    public WorkflowInstanceCreationRecord setBpmnProcessId(DirectBuffer bpmnProcessId) {
        this.bpmnProcessIdProperty.setValue(bpmnProcessId);
        return this;
    }

    public WorkflowInstanceCreationRecord setWorkflowInstanceKey(long instanceKey) {
        this.workflowInstanceKeyProperty.setValue(instanceKey);
        return this;
    }

    public WorkflowInstanceCreationRecord setWorkflowKey(long key) {
        this.workflowKeyProperty.setValue(key);
        return this;
    }

    public WorkflowInstanceCreationRecord setVariables(DirectBuffer variables) {
        this.variablesProperty.setValue(variables);
        return this;
    }

    public WorkflowInstanceCreationRecord setVersion(int version) {
        this.versionProperty.setValue(version);
        return this;
    }
}

