/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.impl.record.value.variable;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.zeebe.msgpack.property.BaseProperty;
import io.zeebe.msgpack.property.BinaryProperty;
import io.zeebe.msgpack.property.LongProperty;
import io.zeebe.msgpack.property.StringProperty;
import io.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.zeebe.protocol.record.value.VariableRecordValue;
import io.zeebe.protocol.record.value.WorkflowInstanceRelated;
import io.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

public class VariableRecord
extends UnifiedRecordValue
implements WorkflowInstanceRelated,
VariableRecordValue {
    private final StringProperty nameProp = new StringProperty("name");
    private final BinaryProperty valueProp = new BinaryProperty("value");
    private final LongProperty scopeKeyProp = new LongProperty("scopeKey");
    private final LongProperty workflowInstanceKeyProp = new LongProperty("workflowInstanceKey");
    private final LongProperty workflowKeyProp = new LongProperty("workflowKey");

    public VariableRecord() {
        this.declareProperty((BaseProperty)this.nameProp).declareProperty((BaseProperty)this.valueProp).declareProperty((BaseProperty)this.scopeKeyProp).declareProperty((BaseProperty)this.workflowInstanceKeyProp).declareProperty((BaseProperty)this.workflowKeyProp);
    }

    public String getName() {
        return BufferUtil.bufferAsString((DirectBuffer)this.nameProp.getValue());
    }

    public String getValue() {
        return MsgPackConverter.convertToJson(this.valueProp.getValue());
    }

    public long getScopeKey() {
        return this.scopeKeyProp.getValue();
    }

    public long getWorkflowKey() {
        return this.workflowKeyProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getNameBuffer() {
        return this.nameProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getValueBuffer() {
        return this.valueProp.getValue();
    }

    public long getWorkflowInstanceKey() {
        return this.workflowInstanceKeyProp.getValue();
    }

    public VariableRecord setName(DirectBuffer name) {
        this.nameProp.setValue(name);
        return this;
    }

    public VariableRecord setScopeKey(long scopeKey) {
        this.scopeKeyProp.setValue(scopeKey);
        return this;
    }

    public VariableRecord setValue(DirectBuffer value) {
        this.valueProp.setValue(value);
        return this;
    }

    public VariableRecord setWorkflowInstanceKey(long workflowInstanceKey) {
        this.workflowInstanceKeyProp.setValue(workflowInstanceKey);
        return this;
    }

    public VariableRecord setWorkflowKey(long workflowKey) {
        this.workflowKeyProp.setValue(workflowKey);
        return this;
    }
}

