/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.impl.record.value.message;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.zeebe.msgpack.property.BaseProperty;
import io.zeebe.msgpack.property.BooleanProperty;
import io.zeebe.msgpack.property.DocumentProperty;
import io.zeebe.msgpack.property.IntegerProperty;
import io.zeebe.msgpack.property.LongProperty;
import io.zeebe.msgpack.property.StringProperty;
import io.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.zeebe.protocol.record.value.WorkflowInstanceRelated;
import io.zeebe.protocol.record.value.WorkflowInstanceSubscriptionRecordValue;
import io.zeebe.util.buffer.BufferUtil;
import java.util.Map;
import org.agrona.DirectBuffer;

public class WorkflowInstanceSubscriptionRecord
extends UnifiedRecordValue
implements WorkflowInstanceRelated,
WorkflowInstanceSubscriptionRecordValue {
    private final IntegerProperty subscriptionPartitionIdProp = new IntegerProperty("subscriptionPartitionId");
    private final LongProperty workflowInstanceKeyProp = new LongProperty("workflowInstanceKey");
    private final LongProperty elementInstanceKeyProp = new LongProperty("elementInstanceKey");
    private final LongProperty messageKeyProp = new LongProperty("messageKey");
    private final StringProperty messageNameProp = new StringProperty("messageName", "");
    private final DocumentProperty variablesProp = new DocumentProperty("variables");
    private final BooleanProperty closeOnCorrelateProp = new BooleanProperty("closeOnCorrelate", true);

    public WorkflowInstanceSubscriptionRecord() {
        this.declareProperty((BaseProperty)this.subscriptionPartitionIdProp).declareProperty((BaseProperty)this.workflowInstanceKeyProp).declareProperty((BaseProperty)this.elementInstanceKeyProp).declareProperty((BaseProperty)this.messageKeyProp).declareProperty((BaseProperty)this.messageNameProp).declareProperty((BaseProperty)this.variablesProp).declareProperty((BaseProperty)this.closeOnCorrelateProp);
    }

    public boolean shouldCloseOnCorrelate() {
        return this.closeOnCorrelateProp.getValue();
    }

    public long getElementInstanceKey() {
        return this.elementInstanceKeyProp.getValue();
    }

    public String getMessageName() {
        return BufferUtil.bufferAsString((DirectBuffer)this.messageNameProp.getValue());
    }

    @JsonIgnore
    public long getMessageKey() {
        return this.messageKeyProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getMessageNameBuffer() {
        return this.messageNameProp.getValue();
    }

    @JsonIgnore
    public int getSubscriptionPartitionId() {
        return this.subscriptionPartitionIdProp.getValue();
    }

    public Map<String, Object> getVariables() {
        return MsgPackConverter.convertToMap(this.variablesProp.getValue());
    }

    @JsonIgnore
    public DirectBuffer getVariablesBuffer() {
        return this.variablesProp.getValue();
    }

    public long getWorkflowInstanceKey() {
        return this.workflowInstanceKeyProp.getValue();
    }

    public WorkflowInstanceSubscriptionRecord setCloseOnCorrelate(boolean closeOnCorrelate) {
        this.closeOnCorrelateProp.setValue(closeOnCorrelate);
        return this;
    }

    public WorkflowInstanceSubscriptionRecord setElementInstanceKey(long key) {
        this.elementInstanceKeyProp.setValue(key);
        return this;
    }

    public WorkflowInstanceSubscriptionRecord setMessageKey(long messageKey) {
        this.messageKeyProp.setValue(messageKey);
        return this;
    }

    public WorkflowInstanceSubscriptionRecord setMessageName(DirectBuffer messageName) {
        this.messageNameProp.setValue(messageName);
        return this;
    }

    public WorkflowInstanceSubscriptionRecord setSubscriptionPartitionId(int partitionId) {
        this.subscriptionPartitionIdProp.setValue(partitionId);
        return this;
    }

    public WorkflowInstanceSubscriptionRecord setVariables(DirectBuffer variables) {
        this.variablesProp.setValue(variables);
        return this;
    }

    public WorkflowInstanceSubscriptionRecord setWorkflowInstanceKey(long key) {
        this.workflowInstanceKeyProp.setValue(key);
        return this;
    }
}

