/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.impl.record.value.message;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.zeebe.msgpack.property.BaseProperty;
import io.zeebe.msgpack.property.BooleanProperty;
import io.zeebe.msgpack.property.LongProperty;
import io.zeebe.msgpack.property.StringProperty;
import io.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.zeebe.protocol.record.value.MessageSubscriptionRecordValue;
import io.zeebe.protocol.record.value.WorkflowInstanceRelated;
import io.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

public class MessageSubscriptionRecord
extends UnifiedRecordValue
implements WorkflowInstanceRelated,
MessageSubscriptionRecordValue {
    private final LongProperty workflowInstanceKeyProp = new LongProperty("workflowInstanceKey");
    private final LongProperty elementInstanceKeyProp = new LongProperty("elementInstanceKey");
    private final LongProperty messageKeyProp = new LongProperty("messageKey");
    private final StringProperty messageNameProp = new StringProperty("messageName", "");
    private final StringProperty correlationKeyProp = new StringProperty("correlationKey", "");
    private final BooleanProperty closeOnCorrelateProp = new BooleanProperty("closeOnCorrelate", true);

    public MessageSubscriptionRecord() {
        this.declareProperty((BaseProperty)this.workflowInstanceKeyProp).declareProperty((BaseProperty)this.elementInstanceKeyProp).declareProperty((BaseProperty)this.messageKeyProp).declareProperty((BaseProperty)this.messageNameProp).declareProperty((BaseProperty)this.correlationKeyProp).declareProperty((BaseProperty)this.closeOnCorrelateProp);
    }

    public boolean shouldCloseOnCorrelate() {
        return this.closeOnCorrelateProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getCorrelationKeyBuffer() {
        return this.correlationKeyProp.getValue();
    }

    public long getElementInstanceKey() {
        return this.elementInstanceKeyProp.getValue();
    }

    public String getMessageName() {
        return BufferUtil.bufferAsString((DirectBuffer)this.messageNameProp.getValue());
    }

    public String getCorrelationKey() {
        return BufferUtil.bufferAsString((DirectBuffer)this.correlationKeyProp.getValue());
    }

    @JsonIgnore
    public long getMessageKey() {
        return this.messageKeyProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getMessageNameBuffer() {
        return this.messageNameProp.getValue();
    }

    public long getWorkflowInstanceKey() {
        return this.workflowInstanceKeyProp.getValue();
    }

    public MessageSubscriptionRecord setCloseOnCorrelate(boolean closeOnCorrelate) {
        this.closeOnCorrelateProp.setValue(closeOnCorrelate);
        return this;
    }

    public MessageSubscriptionRecord setCorrelationKey(DirectBuffer correlationKey) {
        this.correlationKeyProp.setValue(correlationKey);
        return this;
    }

    public MessageSubscriptionRecord setElementInstanceKey(long key) {
        this.elementInstanceKeyProp.setValue(key);
        return this;
    }

    public MessageSubscriptionRecord setMessageKey(long messageKey) {
        this.messageKeyProp.setValue(messageKey);
        return this;
    }

    public MessageSubscriptionRecord setMessageName(DirectBuffer messageName) {
        this.messageNameProp.setValue(messageName);
        return this;
    }

    public MessageSubscriptionRecord setWorkflowInstanceKey(long key) {
        this.workflowInstanceKeyProp.setValue(key);
        return this;
    }
}

