/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.impl.record.value.job;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.zeebe.msgpack.property.BaseProperty;
import io.zeebe.msgpack.property.DocumentProperty;
import io.zeebe.msgpack.property.IntegerProperty;
import io.zeebe.msgpack.property.LongProperty;
import io.zeebe.msgpack.property.PackedProperty;
import io.zeebe.msgpack.property.StringProperty;
import io.zeebe.msgpack.spec.MsgPackHelper;
import io.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.zeebe.protocol.record.value.JobRecordValue;
import io.zeebe.util.buffer.BufferUtil;
import java.util.Map;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class JobRecord
extends UnifiedRecordValue
implements JobRecordValue {
    private static final String EMPTY_STRING = "";
    private static final String RETRIES = "retries";
    private static final String TYPE = "type";
    private static final String CUSTOM_HEADERS = "customHeaders";
    private static final String VARIABLES = "variables";
    private static final String ERROR_MESSAGE = "errorMessage";
    public static final DirectBuffer NO_HEADERS = new UnsafeBuffer(MsgPackHelper.EMTPY_OBJECT);
    private final LongProperty deadlineProp = new LongProperty("deadline", -1L);
    private final StringProperty workerProp = new StringProperty("worker", "");
    private final IntegerProperty retriesProp = new IntegerProperty("retries", -1);
    private final StringProperty typeProp = new StringProperty("type", "");
    private final PackedProperty customHeadersProp = new PackedProperty("customHeaders", NO_HEADERS);
    private final DocumentProperty variableProp = new DocumentProperty("variables");
    private final StringProperty errorMessageProp = new StringProperty("errorMessage", "");
    private final LongProperty workflowInstanceKeyProp = new LongProperty("workflowInstanceKey", -1L);
    private final StringProperty bpmnProcessIdProp = new StringProperty("bpmnProcessId", "");
    private final IntegerProperty workflowDefinitionVersionProp = new IntegerProperty("workflowDefinitionVersion", -1);
    private final LongProperty workflowKeyProp = new LongProperty("workflowKey", -1L);
    private final StringProperty elementIdProp = new StringProperty("elementId", "");
    private final LongProperty elementInstanceKeyProp = new LongProperty("elementInstanceKey", -1L);

    public JobRecord() {
        this.declareProperty((BaseProperty)this.deadlineProp).declareProperty((BaseProperty)this.workerProp).declareProperty((BaseProperty)this.retriesProp).declareProperty((BaseProperty)this.typeProp).declareProperty((BaseProperty)this.customHeadersProp).declareProperty((BaseProperty)this.variableProp).declareProperty((BaseProperty)this.errorMessageProp).declareProperty((BaseProperty)this.bpmnProcessIdProp).declareProperty((BaseProperty)this.workflowDefinitionVersionProp).declareProperty((BaseProperty)this.workflowKeyProp).declareProperty((BaseProperty)this.workflowInstanceKeyProp).declareProperty((BaseProperty)this.elementIdProp).declareProperty((BaseProperty)this.elementInstanceKeyProp);
    }

    public JobRecord resetVariables() {
        this.variableProp.reset();
        return this;
    }

    @JsonIgnore
    public DirectBuffer getCustomHeadersBuffer() {
        return this.customHeadersProp.getValue();
    }

    public long getDeadline() {
        return this.deadlineProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getErrorMessageBuffer() {
        return this.errorMessageProp.getValue();
    }

    public String getType() {
        return BufferUtil.bufferAsString((DirectBuffer)this.typeProp.getValue());
    }

    public Map<String, String> getCustomHeaders() {
        return MsgPackConverter.convertToStringMap(this.customHeadersProp.getValue());
    }

    public String getWorker() {
        return BufferUtil.bufferAsString((DirectBuffer)this.workerProp.getValue());
    }

    public int getRetries() {
        return this.retriesProp.getValue();
    }

    public String getErrorMessage() {
        return BufferUtil.bufferAsString((DirectBuffer)this.errorMessageProp.getValue());
    }

    @JsonIgnore
    public DirectBuffer getTypeBuffer() {
        return this.typeProp.getValue();
    }

    public Map<String, Object> getVariables() {
        return MsgPackConverter.convertToMap(this.variableProp.getValue());
    }

    @JsonIgnore
    public DirectBuffer getVariablesBuffer() {
        return this.variableProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getWorkerBuffer() {
        return this.workerProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getBpmnProcessIdBuffer() {
        return this.bpmnProcessIdProp.getValue();
    }

    public String getElementId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.elementIdProp.getValue());
    }

    public long getElementInstanceKey() {
        return this.elementInstanceKeyProp.getValue();
    }

    public String getBpmnProcessId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.bpmnProcessIdProp.getValue());
    }

    public int getWorkflowDefinitionVersion() {
        return this.workflowDefinitionVersionProp.getValue();
    }

    public long getWorkflowInstanceKey() {
        return this.workflowInstanceKeyProp.getValue();
    }

    public long getWorkflowKey() {
        return this.workflowKeyProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getElementIdBuffer() {
        return this.elementIdProp.getValue();
    }

    public JobRecord setBpmnProcessId(String bpmnProcessId) {
        this.bpmnProcessIdProp.setValue(bpmnProcessId);
        return this;
    }

    public JobRecord setBpmnProcessId(DirectBuffer bpmnProcessId) {
        this.bpmnProcessIdProp.setValue(bpmnProcessId);
        return this;
    }

    public JobRecord setElementId(String elementId) {
        this.elementIdProp.setValue(elementId);
        return this;
    }

    public JobRecord setElementId(DirectBuffer elementId) {
        return this.setElementId(elementId, 0, elementId.capacity());
    }

    public JobRecord setElementId(DirectBuffer activityId, int offset, int length) {
        this.elementIdProp.setValue(activityId, offset, length);
        return this;
    }

    public JobRecord setElementInstanceKey(long elementInstanceKey) {
        this.elementInstanceKeyProp.setValue(elementInstanceKey);
        return this;
    }

    public JobRecord setWorkflowDefinitionVersion(int version) {
        this.workflowDefinitionVersionProp.setValue(version);
        return this;
    }

    public JobRecord setWorkflowInstanceKey(long key) {
        this.workflowInstanceKeyProp.setValue(key);
        return this;
    }

    public JobRecord setWorkflowKey(long workflowKey) {
        this.workflowKeyProp.setValue(workflowKey);
        return this;
    }

    public JobRecord setCustomHeaders(DirectBuffer buffer) {
        this.customHeadersProp.setValue(buffer, 0, buffer.capacity());
        return this;
    }

    public JobRecord setDeadline(long val) {
        this.deadlineProp.setValue(val);
        return this;
    }

    public JobRecord setErrorMessage(String errorMessage) {
        this.errorMessageProp.setValue(errorMessage);
        return this;
    }

    public JobRecord setErrorMessage(DirectBuffer buf) {
        return this.setErrorMessage(buf, 0, buf.capacity());
    }

    public JobRecord setErrorMessage(DirectBuffer buf, int offset, int length) {
        this.errorMessageProp.setValue(buf, offset, length);
        return this;
    }

    public JobRecord setRetries(int retries) {
        this.retriesProp.setValue(retries);
        return this;
    }

    public JobRecord setType(String type) {
        this.typeProp.setValue(type);
        return this;
    }

    public JobRecord setType(DirectBuffer buf) {
        return this.setType(buf, 0, buf.capacity());
    }

    public JobRecord setType(DirectBuffer buf, int offset, int length) {
        this.typeProp.setValue(buf, offset, length);
        return this;
    }

    public JobRecord setVariables(DirectBuffer variables) {
        this.variableProp.setValue(variables);
        return this;
    }

    public JobRecord setWorker(String worker) {
        this.workerProp.setValue(worker);
        return this;
    }

    public JobRecord setWorker(DirectBuffer worker) {
        return this.setWorker(worker, 0, worker.capacity());
    }

    public JobRecord setWorker(DirectBuffer worker, int offset, int length) {
        this.workerProp.setValue(worker, offset, length);
        return this;
    }
}

