/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.impl.record.value.job;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.zeebe.msgpack.property.ArrayProperty;
import io.zeebe.msgpack.property.BaseProperty;
import io.zeebe.msgpack.property.BooleanProperty;
import io.zeebe.msgpack.property.IntegerProperty;
import io.zeebe.msgpack.property.LongProperty;
import io.zeebe.msgpack.property.StringProperty;
import io.zeebe.msgpack.value.BaseValue;
import io.zeebe.msgpack.value.LongValue;
import io.zeebe.msgpack.value.StringValue;
import io.zeebe.msgpack.value.ValueArray;
import io.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.zeebe.protocol.impl.record.value.job.JobRecord;
import io.zeebe.protocol.record.value.JobBatchRecordValue;
import io.zeebe.protocol.record.value.JobRecordValue;
import io.zeebe.util.buffer.BufferUtil;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class JobBatchRecord
extends UnifiedRecordValue
implements JobBatchRecordValue {
    private final StringProperty typeProp = new StringProperty("type");
    private final StringProperty workerProp = new StringProperty("worker", "");
    private final LongProperty timeoutProp = new LongProperty("timeout", -1L);
    private final IntegerProperty maxJobsToActivateProp = new IntegerProperty("maxJobsToActivate", -1);
    private final ArrayProperty<LongValue> jobKeysProp = new ArrayProperty("jobKeys", (BaseValue)new LongValue());
    private final ArrayProperty<JobRecord> jobsProp = new ArrayProperty("jobs", (BaseValue)new JobRecord());
    private final ArrayProperty<StringValue> variablesProp = new ArrayProperty("variables", (BaseValue)new StringValue());
    private final BooleanProperty truncatedProp = new BooleanProperty("truncated", false);

    public JobBatchRecord() {
        this.declareProperty((BaseProperty)this.typeProp).declareProperty((BaseProperty)this.workerProp).declareProperty((BaseProperty)this.timeoutProp).declareProperty((BaseProperty)this.maxJobsToActivateProp).declareProperty(this.jobKeysProp).declareProperty(this.jobsProp).declareProperty(this.variablesProp).declareProperty((BaseProperty)this.truncatedProp);
    }

    public JobBatchRecord setType(DirectBuffer buf, int offset, int length) {
        this.typeProp.setValue(buf, offset, length);
        return this;
    }

    public JobBatchRecord setWorker(DirectBuffer worker, int offset, int length) {
        this.workerProp.setValue(worker, offset, length);
        return this;
    }

    public ValueArray<LongValue> jobKeys() {
        return this.jobKeysProp;
    }

    public ValueArray<JobRecord> jobs() {
        return this.jobsProp;
    }

    public ValueArray<StringValue> variables() {
        return this.variablesProp;
    }

    public long getTimeout() {
        return this.timeoutProp.getValue();
    }

    public boolean getTruncated() {
        return this.truncatedProp.getValue();
    }

    public String getType() {
        return BufferUtil.bufferAsString((DirectBuffer)this.typeProp.getValue());
    }

    public String getWorker() {
        return BufferUtil.bufferAsString((DirectBuffer)this.workerProp.getValue());
    }

    public int getMaxJobsToActivate() {
        return this.maxJobsToActivateProp.getValue();
    }

    public List<Long> getJobKeys() {
        return StreamSupport.stream(this.jobKeysProp.spliterator(), false).map(LongValue::getValue).collect(Collectors.toList());
    }

    public List<JobRecordValue> getJobs() {
        return StreamSupport.stream(this.jobsProp.spliterator(), false).map(jobRecord -> {
            byte[] bytes = new byte[jobRecord.getLength()];
            UnsafeBuffer copyRecord = new UnsafeBuffer(bytes);
            JobRecord copiedRecord = new JobRecord();
            jobRecord.write((MutableDirectBuffer)copyRecord, 0);
            copiedRecord.wrap((DirectBuffer)copyRecord);
            return copiedRecord;
        }).collect(Collectors.toList());
    }

    public boolean isTruncated() {
        return this.truncatedProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getTypeBuffer() {
        return this.typeProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getWorkerBuffer() {
        return this.workerProp.getValue();
    }

    public JobBatchRecord setMaxJobsToActivate(int maxJobsToActivate) {
        this.maxJobsToActivateProp.setValue(maxJobsToActivate);
        return this;
    }

    public JobBatchRecord setTimeout(long val) {
        this.timeoutProp.setValue(val);
        return this;
    }

    public JobBatchRecord setTruncated(boolean truncated) {
        this.truncatedProp.setValue(truncated);
        return this;
    }

    public JobBatchRecord setType(DirectBuffer buf) {
        this.typeProp.setValue(buf);
        return this;
    }

    public JobBatchRecord setType(String type) {
        this.typeProp.setValue(type);
        return this;
    }

    public JobBatchRecord setWorker(DirectBuffer worker) {
        this.workerProp.setValue(worker);
        return this;
    }

    public JobBatchRecord setWorker(String worker) {
        this.workerProp.setValue(worker);
        return this;
    }
}

