/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.impl.record.value.incident;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.zeebe.msgpack.property.BaseProperty;
import io.zeebe.msgpack.property.EnumProperty;
import io.zeebe.msgpack.property.LongProperty;
import io.zeebe.msgpack.property.StringProperty;
import io.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.zeebe.protocol.impl.record.value.workflowinstance.WorkflowInstanceRecord;
import io.zeebe.protocol.record.value.ErrorType;
import io.zeebe.protocol.record.value.IncidentRecordValue;
import io.zeebe.protocol.record.value.WorkflowInstanceRelated;
import io.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

public class IncidentRecord
extends UnifiedRecordValue
implements WorkflowInstanceRelated,
IncidentRecordValue {
    private final EnumProperty<ErrorType> errorTypeProp = new EnumProperty("errorType", ErrorType.class, (Enum)ErrorType.UNKNOWN);
    private final StringProperty errorMessageProp = new StringProperty("errorMessage", "");
    private final StringProperty bpmnProcessIdProp = new StringProperty("bpmnProcessId", "");
    private final LongProperty workflowKeyProp = new LongProperty("workflowKey", -1L);
    private final LongProperty workflowInstanceKeyProp = new LongProperty("workflowInstanceKey", -1L);
    private final StringProperty elementIdProp = new StringProperty("elementId", "");
    private final LongProperty elementInstanceKeyProp = new LongProperty("elementInstanceKey", -1L);
    private final LongProperty jobKeyProp = new LongProperty("jobKey", -1L);
    private final LongProperty variableScopeKeyProp = new LongProperty("variableScopeKey", -1L);

    public IncidentRecord() {
        this.declareProperty((BaseProperty)this.errorTypeProp).declareProperty((BaseProperty)this.errorMessageProp).declareProperty((BaseProperty)this.bpmnProcessIdProp).declareProperty((BaseProperty)this.workflowKeyProp).declareProperty((BaseProperty)this.workflowInstanceKeyProp).declareProperty((BaseProperty)this.elementIdProp).declareProperty((BaseProperty)this.elementInstanceKeyProp).declareProperty((BaseProperty)this.jobKeyProp).declareProperty((BaseProperty)this.variableScopeKeyProp);
    }

    public IncidentRecord initFromWorkflowInstanceFailure(long key, WorkflowInstanceRecord workflowInstanceEvent) {
        this.setElementInstanceKey(key);
        this.setBpmnProcessId(workflowInstanceEvent.getBpmnProcessIdBuffer());
        this.setWorkflowKey(workflowInstanceEvent.getWorkflowKey());
        this.setWorkflowInstanceKey(workflowInstanceEvent.getWorkflowInstanceKey());
        this.setElementId(workflowInstanceEvent.getElementIdBuffer());
        this.setVariableScopeKey(key);
        return this;
    }

    public IncidentRecord setBpmnProcessId(DirectBuffer directBuffer) {
        this.bpmnProcessIdProp.setValue(directBuffer, 0, directBuffer.capacity());
        return this;
    }

    public IncidentRecord setElementId(DirectBuffer elementId) {
        this.elementIdProp.setValue(elementId, 0, elementId.capacity());
        return this;
    }

    public IncidentRecord setWorkflowKey(long workflowKey) {
        this.workflowKeyProp.setValue(workflowKey);
        return this;
    }

    public IncidentRecord setWorkflowInstanceKey(long workflowInstanceKey) {
        this.workflowInstanceKeyProp.setValue(workflowInstanceKey);
        return this;
    }

    public IncidentRecord setElementInstanceKey(long elementInstanceKey) {
        this.elementInstanceKeyProp.setValue(elementInstanceKey);
        return this;
    }

    public IncidentRecord setVariableScopeKey(long variableScopeKey) {
        this.variableScopeKeyProp.setValue(variableScopeKey);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getBpmnProcessIdBuffer() {
        return this.bpmnProcessIdProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getElementIdBuffer() {
        return this.elementIdProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getErrorMessageBuffer() {
        return this.errorMessageProp.getValue();
    }

    public ErrorType getErrorType() {
        return (ErrorType)this.errorTypeProp.getValue();
    }

    public String getErrorMessage() {
        return BufferUtil.bufferAsString((DirectBuffer)this.errorMessageProp.getValue());
    }

    public String getBpmnProcessId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.bpmnProcessIdProp.getValue());
    }

    public long getWorkflowKey() {
        return this.workflowKeyProp.getValue();
    }

    public String getElementId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.elementIdProp.getValue());
    }

    public long getElementInstanceKey() {
        return this.elementInstanceKeyProp.getValue();
    }

    public long getJobKey() {
        return this.jobKeyProp.getValue();
    }

    public long getVariableScopeKey() {
        return this.variableScopeKeyProp.getValue();
    }

    public long getWorkflowInstanceKey() {
        return this.workflowInstanceKeyProp.getValue();
    }

    public IncidentRecord setErrorMessage(DirectBuffer errorMessage) {
        this.errorMessageProp.setValue(errorMessage);
        return this;
    }

    public IncidentRecord setErrorMessage(String errorMessage) {
        this.errorMessageProp.setValue(errorMessage);
        return this;
    }

    public IncidentRecord setErrorType(ErrorType errorType) {
        this.errorTypeProp.setValue((Enum)errorType);
        return this;
    }

    public IncidentRecord setJobKey(long jobKey) {
        this.jobKeyProp.setValue(jobKey);
        return this;
    }
}

