/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.impl.record.value.error;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.zeebe.msgpack.property.BaseProperty;
import io.zeebe.msgpack.property.LongProperty;
import io.zeebe.msgpack.property.StringProperty;
import io.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.zeebe.protocol.record.value.ErrorRecordValue;
import io.zeebe.util.buffer.BufferUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Objects;
import org.agrona.DirectBuffer;

public class ErrorRecord
extends UnifiedRecordValue
implements ErrorRecordValue {
    private static final String NULL_MESSAGE = "Without exception message.";
    private final StringProperty exceptionMessageProp = new StringProperty("exceptionMessage");
    private final StringProperty stacktraceProp = new StringProperty("stacktrace", "");
    private final LongProperty errorEventPositionProp = new LongProperty("errorEventPosition");
    private final LongProperty workflowInstanceKeyProp = new LongProperty("workflowInstanceKey", -1L);

    public ErrorRecord() {
        this.declareProperty((BaseProperty)this.exceptionMessageProp).declareProperty((BaseProperty)this.stacktraceProp).declareProperty((BaseProperty)this.errorEventPositionProp).declareProperty((BaseProperty)this.workflowInstanceKeyProp);
    }

    public void initErrorRecord(Throwable throwable, long position) {
        Objects.requireNonNull(throwable);
        this.reset();
        StringWriter stringWriter = new StringWriter();
        PrintWriter pw = new PrintWriter(stringWriter);
        throwable.printStackTrace(pw);
        this.stacktraceProp.setValue(stringWriter.toString());
        String exceptionMessage = throwable.getMessage();
        this.exceptionMessageProp.setValue(exceptionMessage == null ? NULL_MESSAGE : exceptionMessage);
        this.errorEventPositionProp.setValue(position);
    }

    @JsonIgnore
    public DirectBuffer getExceptionMessageBuffer() {
        return this.exceptionMessageProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getStacktraceBuffer() {
        return this.stacktraceProp.getValue();
    }

    public long getErrorEventPosition() {
        return this.errorEventPositionProp.getValue();
    }

    public long getWorkflowInstanceKey() {
        return this.workflowInstanceKeyProp.getValue();
    }

    public ErrorRecord setWorkflowInstanceKey(long workflowInstanceKey) {
        this.workflowInstanceKeyProp.setValue(workflowInstanceKey);
        return this;
    }

    public String getExceptionMessage() {
        return BufferUtil.bufferAsString((DirectBuffer)this.exceptionMessageProp.getValue());
    }

    public String getStacktrace() {
        return BufferUtil.bufferAsString((DirectBuffer)this.stacktraceProp.getValue());
    }
}

