/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.impl.record;

import io.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.zeebe.protocol.impl.record.RecordMetadata;
import io.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.zeebe.protocol.record.JsonSerializable;
import io.zeebe.protocol.record.Record;
import io.zeebe.protocol.record.RecordType;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.ValueType;
import io.zeebe.protocol.record.intent.Intent;

public class CopiedRecord<T extends UnifiedRecordValue>
implements Record<T> {
    private final T recordValue;
    private final long key;
    private final long position;
    private final long sourcePosition;
    private final long timestamp;
    private final RecordType recordType;
    private final Intent intent;
    private final int partitionId;
    protected ValueType valueType;
    private final RejectionType rejectionType;
    private final String rejectionReason;

    public CopiedRecord(T recordValue, RecordMetadata metadata, long key, int partitionId, long position, long sourcePosition, long timestamp) {
        this.recordValue = recordValue;
        this.key = key;
        this.position = position;
        this.sourcePosition = sourcePosition;
        this.timestamp = timestamp;
        this.intent = metadata.getIntent();
        this.recordType = metadata.getRecordType();
        this.partitionId = partitionId;
        this.rejectionType = metadata.getRejectionType();
        this.rejectionReason = metadata.getRejectionReason();
        this.valueType = metadata.getValueType();
    }

    public long getPosition() {
        return this.position;
    }

    public long getSourceRecordPosition() {
        return this.sourcePosition;
    }

    public long getKey() {
        return this.key;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Intent getIntent() {
        return this.intent;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public RecordType getRecordType() {
        return this.recordType;
    }

    public RejectionType getRejectionType() {
        return this.rejectionType;
    }

    public String getRejectionReason() {
        return this.rejectionReason;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public T getValue() {
        return this.recordValue;
    }

    public String toJson() {
        return MsgPackConverter.convertJsonSerializableObjectToJson((JsonSerializable)this);
    }

    public String toString() {
        return this.toJson();
    }
}

