/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.impl.encoding;

import io.zeebe.protocol.impl.Loggers;
import io.zeebe.protocol.record.BrokerInfoDecoder;
import io.zeebe.protocol.record.BrokerInfoEncoder;
import io.zeebe.protocol.record.MessageHeaderDecoder;
import io.zeebe.protocol.record.MessageHeaderEncoder;
import io.zeebe.protocol.record.PartitionRole;
import io.zeebe.util.buffer.BufferReader;
import io.zeebe.util.buffer.BufferUtil;
import io.zeebe.util.buffer.BufferWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.slf4j.Logger;

public class BrokerInfo
implements BufferReader,
BufferWriter {
    private static final String BROKER_INFO_PROPERTY_NAME = "brokerInfo";
    private static final DirectBuffer COMMAND_API_NAME = BufferUtil.wrapString((String)"commandApi");
    private static final Logger LOG = Loggers.PROTOCOL_LOGGER;
    private static final Base64.Encoder BASE_64_ENCODER = Base64.getEncoder();
    private static final Base64.Decoder BASE_64_DECODER = Base64.getDecoder();
    private static final Charset BASE_64_CHARSET = StandardCharsets.UTF_8;
    private final MessageHeaderEncoder headerEncoder = new MessageHeaderEncoder();
    private final MessageHeaderDecoder headerDecoder = new MessageHeaderDecoder();
    private final BrokerInfoEncoder bodyEncoder = new BrokerInfoEncoder();
    private final BrokerInfoDecoder bodyDecoder = new BrokerInfoDecoder();
    private int nodeId;
    private int partitionsCount;
    private int clusterSize;
    private int replicationFactor;
    private final Map<DirectBuffer, DirectBuffer> addresses = new HashMap<DirectBuffer, DirectBuffer>();
    private final Map<Integer, PartitionRole> partitionRoles = new HashMap<Integer, PartitionRole>();

    public BrokerInfo() {
        this.reset();
    }

    public BrokerInfo reset() {
        this.nodeId = BrokerInfoEncoder.nodeIdNullValue();
        this.partitionsCount = BrokerInfoEncoder.partitionsCountNullValue();
        this.clusterSize = BrokerInfoEncoder.clusterSizeNullValue();
        this.replicationFactor = BrokerInfoEncoder.replicationFactorNullValue();
        this.addresses.clear();
        this.clearPartitions();
        return this;
    }

    public void clearPartitions() {
        this.partitionRoles.clear();
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public BrokerInfo setNodeId(int nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    public int getPartitionsCount() {
        return this.partitionsCount;
    }

    public BrokerInfo setPartitionsCount(int partitionsCount) {
        this.partitionsCount = partitionsCount;
        return this;
    }

    public int getClusterSize() {
        return this.clusterSize;
    }

    public BrokerInfo setClusterSize(int clusterSize) {
        this.clusterSize = clusterSize;
        return this;
    }

    public int getReplicationFactor() {
        return this.replicationFactor;
    }

    public BrokerInfo setReplicationFactor(int replicationFactor) {
        this.replicationFactor = replicationFactor;
        return this;
    }

    public Map<DirectBuffer, DirectBuffer> getAddresses() {
        return this.addresses;
    }

    public BrokerInfo addAddress(DirectBuffer apiName, DirectBuffer address) {
        this.addresses.put(apiName, address);
        return this;
    }

    public BrokerInfo setCommandApiAddress(String address) {
        return this.setCommandApiAddress(BufferUtil.wrapString((String)address));
    }

    public BrokerInfo setCommandApiAddress(DirectBuffer address) {
        return this.addAddress(COMMAND_API_NAME, address);
    }

    public String getCommandApiAddress() {
        DirectBuffer buffer = this.addresses.get(COMMAND_API_NAME);
        if (buffer != null) {
            return BufferUtil.bufferAsString((DirectBuffer)buffer);
        }
        return null;
    }

    public Map<Integer, PartitionRole> getPartitionRoles() {
        return this.partitionRoles;
    }

    public BrokerInfo addPartitionRole(Integer partitionId, PartitionRole role) {
        this.partitionRoles.put(partitionId, role);
        return this;
    }

    public BrokerInfo setFollowerForPartition(int partitionId) {
        return this.addPartitionRole(partitionId, PartitionRole.FOLLOWER);
    }

    public BrokerInfo setLeaderForPartition(int partitionId) {
        return this.addPartitionRole(partitionId, PartitionRole.LEADER);
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        this.reset();
        int frameEnd = offset + length;
        this.headerDecoder.wrap(buffer, offset);
        this.bodyDecoder.wrap(buffer, offset += this.headerDecoder.encodedLength(), this.headerDecoder.blockLength(), this.headerDecoder.version());
        this.nodeId = this.bodyDecoder.nodeId();
        this.partitionsCount = this.bodyDecoder.partitionsCount();
        this.clusterSize = this.bodyDecoder.clusterSize();
        this.replicationFactor = this.bodyDecoder.replicationFactor();
        BrokerInfoDecoder.AddressesDecoder addressesDecoder = this.bodyDecoder.addresses();
        while (addressesDecoder.hasNext()) {
            addressesDecoder.next();
            int apiNameLength = addressesDecoder.apiNameLength();
            byte[] apiNameBytes = new byte[apiNameLength];
            addressesDecoder.getApiName(apiNameBytes, 0, apiNameLength);
            int addressLength = addressesDecoder.addressLength();
            byte[] addressBytes = new byte[addressLength];
            addressesDecoder.getAddress(addressBytes, 0, addressLength);
            this.addAddress((DirectBuffer)new UnsafeBuffer(apiNameBytes), (DirectBuffer)new UnsafeBuffer(addressBytes));
        }
        BrokerInfoDecoder.PartitionRolesDecoder partitionRolesDecoder = this.bodyDecoder.partitionRoles();
        while (partitionRolesDecoder.hasNext()) {
            partitionRolesDecoder.next();
            this.addPartitionRole(partitionRolesDecoder.partitionId(), partitionRolesDecoder.role());
        }
        assert (this.bodyDecoder.limit() == frameEnd) : "Decoder read only to position " + this.bodyDecoder.limit() + " but expected " + frameEnd + " as final position";
    }

    public int getLength() {
        int length = this.headerEncoder.encodedLength() + this.bodyEncoder.sbeBlockLength() + BrokerInfoEncoder.AddressesEncoder.sbeHeaderSize() + BrokerInfoEncoder.PartitionRolesEncoder.sbeHeaderSize();
        for (Map.Entry<DirectBuffer, DirectBuffer> entry : this.addresses.entrySet()) {
            length += BrokerInfoEncoder.AddressesEncoder.sbeBlockLength() + BrokerInfoEncoder.AddressesEncoder.apiNameHeaderLength() + entry.getKey().capacity() + BrokerInfoEncoder.AddressesEncoder.addressHeaderLength() + entry.getValue().capacity();
        }
        return length += this.partitionRoles.size() * BrokerInfoEncoder.PartitionRolesEncoder.sbeBlockLength();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        this.headerEncoder.wrap(buffer, offset).blockLength(this.bodyEncoder.sbeBlockLength()).templateId(this.bodyEncoder.sbeTemplateId()).schemaId(this.bodyEncoder.sbeSchemaId()).version(this.bodyEncoder.sbeSchemaVersion());
        this.bodyEncoder.wrap(buffer, offset += this.headerEncoder.encodedLength()).nodeId(this.nodeId).partitionsCount(this.partitionsCount).clusterSize(this.clusterSize).replicationFactor(this.replicationFactor);
        int addressesCount = this.addresses.size();
        BrokerInfoEncoder.AddressesEncoder addressesEncoder = this.bodyEncoder.addressesCount(addressesCount);
        if (addressesCount > 0) {
            for (Map.Entry<DirectBuffer, DirectBuffer> entry : this.addresses.entrySet()) {
                DirectBuffer apiName = entry.getKey();
                DirectBuffer address = entry.getValue();
                addressesEncoder.next().putApiName(apiName, 0, apiName.capacity()).putAddress(address, 0, address.capacity());
            }
        }
        int partitionRolesCount = this.partitionRoles.size();
        BrokerInfoEncoder.PartitionRolesEncoder partitionRolesEncoder = this.bodyEncoder.partitionRolesCount(partitionRolesCount);
        if (partitionRolesCount > 0) {
            for (Map.Entry<Integer, PartitionRole> entry : this.partitionRoles.entrySet()) {
                partitionRolesEncoder.next().partitionId(entry.getKey().intValue()).role(entry.getValue());
            }
        }
    }

    public static BrokerInfo fromProperties(Properties properties) {
        String property = properties.getProperty(BROKER_INFO_PROPERTY_NAME);
        if (property != null) {
            return BrokerInfo.readFromString(property);
        }
        return null;
    }

    private static BrokerInfo readFromString(String property) {
        byte[] bytes = BASE_64_DECODER.decode(property.getBytes(BASE_64_CHARSET));
        BrokerInfo brokerInfo = new BrokerInfo();
        brokerInfo.wrap((DirectBuffer)new UnsafeBuffer(bytes), 0, bytes.length);
        return brokerInfo;
    }

    public void writeIntoProperties(Properties memberProperties) {
        memberProperties.setProperty(BROKER_INFO_PROPERTY_NAME, this.writeToString());
    }

    private String writeToString() {
        byte[] bytes = new byte[this.getLength()];
        UnsafeBuffer buffer = new UnsafeBuffer(bytes);
        this.write((MutableDirectBuffer)buffer, 0);
        return new String(BASE_64_ENCODER.encode(bytes), BASE_64_CHARSET);
    }

    public BrokerInfo consumePartitions(Consumer<Integer> leaderPartitionConsumer, Consumer<Integer> followerPartitionsConsumer) {
        return this.consumePartitions(p -> {}, leaderPartitionConsumer, followerPartitionsConsumer);
    }

    public BrokerInfo consumePartitions(Consumer<Integer> partitionConsumer, Consumer<Integer> leaderPartitionConsumer, Consumer<Integer> followerPartitionsConsumer) {
        this.partitionRoles.forEach((partition, role) -> {
            partitionConsumer.accept((Integer)partition);
            switch (role) {
                case LEADER: {
                    leaderPartitionConsumer.accept((Integer)partition);
                    break;
                }
                case FOLLOWER: {
                    followerPartitionsConsumer.accept((Integer)partition);
                    break;
                }
                default: {
                    LOG.warn("Failed to decode broker info, found unknown partition role: {}", role);
                }
            }
        });
        return this;
    }

    public String toString() {
        return "BrokerInfo{nodeId=" + this.nodeId + ", partitionsCount=" + this.partitionsCount + ", clusterSize=" + this.clusterSize + ", replicationFactor=" + this.replicationFactor + ", partitionRoles=" + this.partitionRoles + '}';
    }
}

