/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.logstreams.state;

import io.zeebe.logstreams.state.SnapshotChunk;
import io.zeebe.logstreams.state.SnapshotChunkUtil;
import io.zeebe.logstreams.state.SnapshotConsumer;
import io.zeebe.logstreams.state.StateStorage;
import io.zeebe.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.slf4j.Logger;

public class FileSnapshotConsumer
implements SnapshotConsumer {
    private final StateStorage stateStorage;
    private final Logger logger;

    public FileSnapshotConsumer(StateStorage stateStorage, Logger logger) {
        this.stateStorage = stateStorage;
        this.logger = logger;
    }

    @Override
    public boolean consumeSnapshotChunk(SnapshotChunk chunk) {
        return this.writeChunkToDisk(chunk, this.stateStorage);
    }

    @Override
    public boolean completeSnapshot(long snapshotId) {
        return this.moveValidSnapshot(this.stateStorage, snapshotId);
    }

    @Override
    public void invalidateSnapshot(long snapshotId) {
        File tmpSnapshotDirectory = this.stateStorage.getTmpSnapshotDirectoryFor(Long.toString(snapshotId));
        try {
            if (tmpSnapshotDirectory.exists()) {
                FileUtil.deleteFolder((Path)tmpSnapshotDirectory.toPath());
            }
        }
        catch (IOException e) {
            this.logger.debug("Could not delete temporary snapshot directory {}", (Object)tmpSnapshotDirectory.toPath());
        }
    }

    private boolean writeChunkToDisk(SnapshotChunk snapshotChunk, StateStorage storage) {
        File snapshotFile;
        long actualChecksum;
        long snapshotPosition = snapshotChunk.getSnapshotPosition();
        String snapshotName = Long.toString(snapshotPosition);
        String chunkName = snapshotChunk.getChunkName();
        if (storage.existSnapshot(snapshotPosition)) {
            this.logger.debug("Ignore snapshot chunk {}, because snapshot {} already exists.", (Object)chunkName, (Object)snapshotName);
            return true;
        }
        long expectedChecksum = snapshotChunk.getChecksum();
        if (expectedChecksum != (actualChecksum = SnapshotChunkUtil.createChecksum(snapshotChunk.getContent()))) {
            this.logger.warn("Expected to have checksum {} for snapshot chunk file {} ({}), but calculated {}", new Object[]{expectedChecksum, chunkName, snapshotName, actualChecksum});
            return false;
        }
        File tmpSnapshotDirectory = storage.getTmpSnapshotDirectoryFor(snapshotName);
        if (!tmpSnapshotDirectory.exists()) {
            tmpSnapshotDirectory.mkdirs();
        }
        if ((snapshotFile = new File(tmpSnapshotDirectory, chunkName)).exists()) {
            this.logger.debug("Received a snapshot chunk which already exist '{}'.", (Object)snapshotFile);
            return false;
        }
        this.logger.debug("Consume snapshot chunk {}", (Object)chunkName);
        return this.writeReceivedSnapshotChunk(snapshotChunk, snapshotFile);
    }

    private boolean writeReceivedSnapshotChunk(SnapshotChunk snapshotChunk, File snapshotFile) {
        try {
            Files.write(snapshotFile.toPath(), snapshotChunk.getContent(), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
            this.logger.trace("Wrote replicated snapshot chunk to file {}", (Object)snapshotFile.toPath());
            return true;
        }
        catch (IOException ioe) {
            this.logger.error("Unexpected error occurred on writing snapshot chunk to '{}'.", (Object)snapshotFile, (Object)ioe);
            return false;
        }
    }

    private boolean moveValidSnapshot(StateStorage storage, long snapshotId) {
        File validSnapshotDirectory = storage.getSnapshotDirectoryFor(snapshotId);
        File tmpSnapshotDirectory = storage.getTmpSnapshotDirectoryFor(Long.toString(snapshotId));
        try {
            Files.move(tmpSnapshotDirectory.toPath(), validSnapshotDirectory.toPath(), new CopyOption[0]);
            this.logger.debug("Moved snapshot {} to {}", (Object)snapshotId, (Object)validSnapshotDirectory.toPath());
            return true;
        }
        catch (FileAlreadyExistsException e) {
            return true;
        }
        catch (IOException ioe) {
            this.logger.error("Unexpected error occurred when moving snapshot {} to {}", new Object[]{snapshotId, validSnapshotDirectory.toPath(), ioe});
            return false;
        }
    }
}

