/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.logstreams.log;

import io.zeebe.dispatcher.ClaimedFragment;
import io.zeebe.dispatcher.Dispatcher;
import io.zeebe.dispatcher.impl.log.DataFrameDescriptor;
import io.zeebe.logstreams.impl.LogEntryDescriptor;
import io.zeebe.logstreams.log.LogStream;
import io.zeebe.logstreams.log.LogStreamRecordWriter;
import io.zeebe.util.buffer.BufferWriter;
import io.zeebe.util.buffer.DirectBufferWriter;
import io.zeebe.util.sched.clock.ActorClock;
import org.agrona.DirectBuffer;
import org.agrona.LangUtil;
import org.agrona.MutableDirectBuffer;

public class LogStreamWriterImpl
implements LogStreamRecordWriter {
    protected final DirectBufferWriter metadataWriterInstance = new DirectBufferWriter();
    protected final DirectBufferWriter bufferWriterInstance = new DirectBufferWriter();
    protected final ClaimedFragment claimedFragment = new ClaimedFragment();
    private LogStream logStream;
    protected long key;
    protected long sourceRecordPosition = -1L;
    protected BufferWriter metadataWriter;
    protected BufferWriter valueWriter;

    public LogStreamWriterImpl() {
    }

    public LogStreamWriterImpl(LogStream log) {
        this.wrap(log);
    }

    @Override
    public void wrap(LogStream log) {
        this.logStream = log;
        this.reset();
    }

    @Override
    public LogStreamRecordWriter keyNull() {
        return this.key(-1L);
    }

    @Override
    public LogStreamRecordWriter key(long key) {
        this.key = key;
        return this;
    }

    @Override
    public LogStreamRecordWriter sourceRecordPosition(long position) {
        this.sourceRecordPosition = position;
        return this;
    }

    @Override
    public LogStreamRecordWriter metadata(DirectBuffer buffer, int offset, int length) {
        this.metadataWriterInstance.wrap(buffer, offset, length);
        return this;
    }

    @Override
    public LogStreamRecordWriter metadata(DirectBuffer buffer) {
        return this.metadata(buffer, 0, buffer.capacity());
    }

    @Override
    public LogStreamRecordWriter metadataWriter(BufferWriter writer) {
        this.metadataWriter = writer;
        return this;
    }

    @Override
    public LogStreamRecordWriter value(DirectBuffer value, int valueOffset, int valueLength) {
        return this.valueWriter((BufferWriter)this.bufferWriterInstance.wrap(value, valueOffset, valueLength));
    }

    @Override
    public LogStreamRecordWriter value(DirectBuffer value) {
        return this.value(value, 0, value.capacity());
    }

    @Override
    public LogStreamRecordWriter valueWriter(BufferWriter writer) {
        this.valueWriter = writer;
        return this;
    }

    @Override
    public void reset() {
        this.key = -1L;
        this.metadataWriter = this.metadataWriterInstance;
        this.valueWriter = null;
        this.sourceRecordPosition = -1L;
        this.bufferWriterInstance.reset();
        this.metadataWriterInstance.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long tryWrite() {
        int metadataLength;
        if (this.valueWriter == null) {
            return 0L;
        }
        long result = -1L;
        int valueLength = this.valueWriter.getLength();
        long claimedPosition = this.claimLogEntry(valueLength, metadataLength = this.metadataWriter.getLength());
        if (claimedPosition >= 0L) {
            try {
                MutableDirectBuffer writeBuffer = this.claimedFragment.getBuffer();
                int bufferOffset = this.claimedFragment.getOffset();
                LogEntryDescriptor.setPosition(writeBuffer, bufferOffset, claimedPosition);
                LogEntryDescriptor.setSourceEventPosition(writeBuffer, bufferOffset, this.sourceRecordPosition);
                LogEntryDescriptor.setKey(writeBuffer, bufferOffset, this.key);
                LogEntryDescriptor.setTimestamp(writeBuffer, bufferOffset, ActorClock.currentTimeMillis());
                LogEntryDescriptor.setMetadataLength(writeBuffer, bufferOffset, (short)metadataLength);
                if (metadataLength > 0) {
                    this.metadataWriter.write(writeBuffer, LogEntryDescriptor.metadataOffset(bufferOffset));
                }
                this.valueWriter.write(writeBuffer, LogEntryDescriptor.valueOffset(bufferOffset, metadataLength));
                result = claimedPosition;
                this.claimedFragment.commit();
            }
            catch (Exception e) {
                this.claimedFragment.abort();
                LangUtil.rethrowUnchecked((Throwable)e);
            }
            finally {
                this.reset();
            }
        }
        return result;
    }

    private long claimLogEntry(int valueLength, int metadataLength) {
        int framedLength = valueLength + LogEntryDescriptor.headerLength(metadataLength);
        long claimedPosition = -1L;
        Dispatcher logWriteBuffer = this.logStream.getWriteBuffer();
        int logId = this.logStream.getPartitionId();
        while ((claimedPosition = logWriteBuffer.claim(this.claimedFragment, framedLength, logId)) == -2L) {
        }
        return claimedPosition - (long)DataFrameDescriptor.alignedFramedLength((int)framedLength);
    }
}

