/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.logstreams.impl.service;

import io.zeebe.dispatcher.Dispatcher;
import io.zeebe.dispatcher.DispatcherBuilder;
import io.zeebe.dispatcher.Dispatchers;
import io.zeebe.dispatcher.Subscription;
import io.zeebe.logstreams.impl.LogStorageAppender;
import io.zeebe.logstreams.impl.LogStreamBuilder;
import io.zeebe.logstreams.impl.Loggers;
import io.zeebe.logstreams.impl.service.LogStorageAppenderService;
import io.zeebe.logstreams.impl.service.LogStreamServiceNames;
import io.zeebe.logstreams.impl.service.LogWriteBufferService;
import io.zeebe.logstreams.impl.service.LogWriteBufferSubscriptionService;
import io.zeebe.logstreams.log.BufferedLogStreamReader;
import io.zeebe.logstreams.log.LogStream;
import io.zeebe.logstreams.spi.LogStorage;
import io.zeebe.servicecontainer.CompositeServiceBuilder;
import io.zeebe.servicecontainer.Injector;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceContainer;
import io.zeebe.servicecontainer.ServiceName;
import io.zeebe.servicecontainer.ServiceStartContext;
import io.zeebe.servicecontainer.ServiceStopContext;
import io.zeebe.util.ByteValue;
import io.zeebe.util.sched.ActorCondition;
import io.zeebe.util.sched.channel.ActorConditions;
import io.zeebe.util.sched.future.ActorFuture;
import org.agrona.concurrent.status.Position;
import org.slf4j.Logger;

public class LogStreamService
implements LogStream,
Service<LogStream> {
    public static final long INVALID_ADDRESS = -1L;
    private static final Logger LOG = Loggers.LOGSTREAMS_LOGGER;
    private static final String APPENDER_SUBSCRIPTION_NAME = "appender";
    private final Injector<LogStorage> logStorageInjector = new Injector();
    private final ServiceContainer serviceContainer;
    private final ActorConditions onCommitPositionUpdatedConditions;
    private final String logName;
    private final int partitionId;
    private final ByteValue writeBufferSize;
    private final int maxAppendBlockSize;
    private final Position commitPosition;
    private BufferedLogStreamReader reader;
    private ServiceStartContext serviceContext;
    private LogStorage logStorage;
    private ActorFuture<Dispatcher> writeBufferFuture;
    private ActorFuture<LogStorageAppender> appenderFuture;
    private Dispatcher writeBuffer;
    private LogStorageAppender appender;

    public LogStreamService(LogStreamBuilder builder) {
        this.logName = builder.getLogName();
        this.partitionId = builder.getPartitionId();
        this.serviceContainer = builder.getServiceContainer();
        this.onCommitPositionUpdatedConditions = builder.getOnCommitPositionUpdatedConditions();
        this.commitPosition = builder.getCommitPosition();
        this.writeBufferSize = ByteValue.ofBytes((long)builder.getWriteBufferSize());
        this.maxAppendBlockSize = builder.getMaxAppendBlockSize();
    }

    public void start(ServiceStartContext startContext) {
        this.commitPosition.setVolatile(-1L);
        this.serviceContext = startContext;
        this.logStorage = (LogStorage)this.logStorageInjector.getValue();
        this.reader = new BufferedLogStreamReader(this);
    }

    @Override
    public ActorFuture<LogStorageAppender> openAppender() {
        String logName = this.getLogName();
        ServiceName<Void> logStorageAppenderRootService = LogStreamServiceNames.logStorageAppenderRootService(logName);
        ServiceName<Dispatcher> logWriteBufferServiceName = LogStreamServiceNames.logWriteBufferServiceName(logName);
        ServiceName<Subscription> appenderSubscriptionServiceName = LogStreamServiceNames.logWriteBufferSubscriptionServiceName(logName, APPENDER_SUBSCRIPTION_NAME);
        ServiceName<LogStorageAppender> logStorageAppenderServiceName = LogStreamServiceNames.logStorageAppenderServiceName(logName);
        DispatcherBuilder writeBufferBuilder = Dispatchers.create((String)logWriteBufferServiceName.getName()).bufferSize(this.writeBufferSize);
        CompositeServiceBuilder installOperation = this.serviceContext.createComposite(logStorageAppenderRootService);
        LogWriteBufferService writeBufferService = new LogWriteBufferService(writeBufferBuilder);
        this.writeBufferFuture = installOperation.createService(logWriteBufferServiceName, (Service)writeBufferService).dependency(this.logStorageInjector.getInjectedServiceName(), writeBufferService.getLogStorageInjector()).install();
        LogWriteBufferSubscriptionService subscriptionService = new LogWriteBufferSubscriptionService(APPENDER_SUBSCRIPTION_NAME);
        installOperation.createService(appenderSubscriptionServiceName, (Service)subscriptionService).dependency(logWriteBufferServiceName, subscriptionService.getWritebufferInjector()).install();
        LogStorageAppenderService appenderService = new LogStorageAppenderService(this.maxAppendBlockSize);
        this.appenderFuture = installOperation.createService(logStorageAppenderServiceName, (Service)appenderService).dependency(appenderSubscriptionServiceName, appenderService.getAppenderSubscriptionInjector()).dependency(LogStreamServiceNames.distributedLogPartitionServiceName(logName), appenderService.getDistributedLogstreamInjector()).install();
        return installOperation.installAndReturn(logStorageAppenderServiceName);
    }

    @Override
    public ActorFuture<Void> closeAppender() {
        this.appenderFuture = null;
        this.writeBufferFuture = null;
        this.appender = null;
        this.writeBuffer = null;
        String logName = this.getLogName();
        return this.serviceContext.removeService(LogStreamServiceNames.logStorageAppenderRootService(logName));
    }

    public void stop(ServiceStopContext stopContext) {
    }

    public LogStream get() {
        return this;
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public String getLogName() {
        return this.logName;
    }

    @Override
    public void close() {
        this.closeAsync().join();
    }

    @Override
    public ActorFuture<Void> closeAsync() {
        return this.serviceContainer.removeService(LogStreamServiceNames.logStreamRootServiceName(this.logName));
    }

    @Override
    public LogStorage getLogStorage() {
        return this.logStorage;
    }

    @Override
    public Dispatcher getWriteBuffer() {
        if (this.writeBuffer == null && this.writeBufferFuture != null) {
            this.writeBuffer = (Dispatcher)this.writeBufferFuture.join();
        }
        return this.writeBuffer;
    }

    @Override
    public LogStorageAppender getLogStorageAppender() {
        if (this.appender == null && this.appenderFuture != null) {
            this.appender = (LogStorageAppender)((Object)this.appenderFuture.join());
        }
        return this.appender;
    }

    @Override
    public long getCommitPosition() {
        return this.commitPosition.get();
    }

    @Override
    public void delete(long position) {
        boolean positionNotExist;
        boolean bl = positionNotExist = !this.reader.seek(position);
        if (positionNotExist) {
            LOG.debug("Tried to delete from log stream, but found no corresponding address in the log block index for the given position {}.", (Object)position);
            return;
        }
        long blockAddress = this.reader.lastReadAddress();
        LOG.info("Delete data from log stream until position '{}' (address: '{}').", (Object)position, (Object)blockAddress);
        this.logStorage.delete(blockAddress);
    }

    @Override
    public void setCommitPosition(long commitPosition) {
        this.commitPosition.setOrdered(commitPosition);
        this.onCommitPositionUpdatedConditions.signalConsumers();
    }

    @Override
    public void registerOnCommitPositionUpdatedCondition(ActorCondition condition) {
        this.onCommitPositionUpdatedConditions.registerConsumer(condition);
    }

    @Override
    public void removeOnCommitPositionUpdatedCondition(ActorCondition condition) {
        this.onCommitPositionUpdatedConditions.removeConsumer(condition);
    }

    public Injector<LogStorage> getLogStorageInjector() {
        return this.logStorageInjector;
    }
}

