/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.logstreams.impl.log.fs;

import java.io.File;

public class FsLogStorageConfiguration {
    private static final String FRAGMENT_FILE_NAME_TEMPLATE = "%s" + File.separatorChar + "%02d.data";
    private static final String FRAGMENT_FILE_NAME_PATTERN = "\\d+.data";
    private final int segmentSize;
    private final String path;
    private final int initialSegmentId;
    private final boolean deleteOnClose;

    public FsLogStorageConfiguration(int segmentSize, String path, int initialSegmentId, boolean deleteOnClose) {
        this.segmentSize = segmentSize;
        this.path = path;
        this.initialSegmentId = initialSegmentId;
        this.deleteOnClose = deleteOnClose;
    }

    int getSegmentSize() {
        return this.segmentSize;
    }

    public String getPath() {
        return this.path;
    }

    public String fileName(int segmentId) {
        return String.format(FRAGMENT_FILE_NAME_TEMPLATE, this.path, segmentId);
    }

    boolean matchesFragmentFileNamePattern(File file) {
        return this.matchesFileNamePattern(file, FRAGMENT_FILE_NAME_PATTERN);
    }

    private boolean matchesFileNamePattern(File file, String pattern) {
        return file.getName().matches(pattern);
    }

    boolean isDeleteOnClose() {
        return this.deleteOnClose;
    }

    public int getInitialSegmentId() {
        return this.initialSegmentId;
    }
}

