/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.distributedlog.restore.snapshot.impl;

import io.zeebe.distributedlog.restore.RestoreServer;
import io.zeebe.distributedlog.restore.snapshot.SnapshotRestoreRequest;
import io.zeebe.distributedlog.restore.snapshot.SnapshotRestoreResponse;
import io.zeebe.distributedlog.restore.snapshot.impl.InvalidSnapshotRestoreResponse;
import io.zeebe.distributedlog.restore.snapshot.impl.SuccessSnapshotRestoreResponse;
import io.zeebe.logstreams.spi.SnapshotController;
import io.zeebe.logstreams.state.SnapshotChunk;
import io.zeebe.logstreams.state.SnapshotChunkUtil;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.slf4j.Logger;

public class DefaultSnapshotRequestHandler
implements RestoreServer.SnapshotRequestHandler {
    private final SnapshotController snapshotController;

    public DefaultSnapshotRequestHandler(SnapshotController snapshotStorage) {
        this.snapshotController = snapshotStorage;
    }

    @Override
    public SnapshotRestoreResponse onSnapshotRequest(SnapshotRestoreRequest request, Logger logger) {
        File snapshotDirectory = this.snapshotController.getSnapshotDirectoryFor(request.getSnapshotId());
        SnapshotRestoreResponse response = new InvalidSnapshotRestoreResponse();
        logger.debug("Received on demand snapshot request {}", (Object)request);
        if (snapshotDirectory.exists()) {
            Object[] files = snapshotDirectory.listFiles();
            if (files != null && files.length > 0) {
                Arrays.sort(files);
                if (request.getChunkIdx() < files.length) {
                    Object chunkFile = files[request.getChunkIdx()];
                    try {
                        SnapshotChunk snapshotChunk = SnapshotChunkUtil.createSnapshotChunkFromFile((File)chunkFile, request.getSnapshotId(), files.length);
                        response = new SuccessSnapshotRestoreResponse(snapshotChunk);
                    }
                    catch (IOException e) {
                        logger.warn("Unexpected error when reading snapshot chunk file {} ({}) at index {}.", new Object[]{((File)chunkFile).toString(), request.getSnapshotId(), request.getChunkIdx(), e});
                    }
                }
            } else {
                logger.debug("No snapshot files available ({}) but directory {} is present", (Object)files, (Object)snapshotDirectory);
            }
        }
        logger.debug("Responding on demand snapshot request with {}", (Object)response);
        return response;
    }
}

